/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler;

import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerFilter;
import com.intellij.openapi.compiler.TranslatingCompiler;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Set;

public abstract class CompilerManager {
    @Deprecated
    public static final Key<Key> CONTENT_ID_KEY = Key.create((String)"COMPILATION_CONTENT_ID_CUSTOM_KEY");
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.logOnlyGroup("Compiler");

    public static CompilerManager getInstance(Project project) {
        return ServiceManager.getService(project, CompilerManager.class);
    }

    public abstract boolean isCompilationActive();

    public abstract void addCompiler(Compiler var1);

    public abstract void addTranslatingCompiler(TranslatingCompiler var1, Set<FileType> var2, Set<FileType> var3);

    public abstract void removeCompiler(Compiler var1);

    public abstract <T extends Compiler> T[] getCompilers(Class<T> var1);

    public abstract <T extends Compiler> T[] getCompilers(Class<T> var1, CompilerFilter var2);

    public abstract void addCompilableFileType(FileType var1);

    public abstract void removeCompilableFileType(FileType var1);

    public abstract boolean isCompilableFileType(FileType var1);

    public abstract void addBeforeTask(CompileTask var1);

    public abstract void addAfterTask(CompileTask var1);

    public abstract CompileTask[] getBeforeTasks();

    public abstract CompileTask[] getAfterTasks();

    public abstract void compile(VirtualFile[] var1, CompileStatusNotification var2);

    public abstract void compile(Module var1, CompileStatusNotification var2);

    public abstract void compile(CompileScope var1, CompileStatusNotification var2);

    public abstract void make(CompileStatusNotification var1);

    public abstract void make(Module var1, CompileStatusNotification var2);

    public abstract void make(Project var1, Module[] var2, CompileStatusNotification var3);

    public abstract void make(CompileScope var1, CompileStatusNotification var2);

    public abstract void make(CompileScope var1, CompilerFilter var2, CompileStatusNotification var3);

    public abstract boolean isUpToDate(CompileScope var1);

    public abstract void rebuild(CompileStatusNotification var1);

    public abstract void executeTask(CompileTask var1, CompileScope var2, String var3, Runnable var4);

    public abstract void addCompilationStatusListener(CompilationStatusListener var1);

    public abstract void addCompilationStatusListener(CompilationStatusListener var1, Disposable var2);

    public abstract void removeCompilationStatusListener(CompilationStatusListener var1);

    public abstract boolean isExcludedFromCompilation(VirtualFile var1);

    public abstract CompileScope createFilesCompileScope(VirtualFile[] var1);

    public abstract CompileScope createModuleCompileScope(Module var1, boolean var2);

    public abstract CompileScope createModulesCompileScope(Module[] var1, boolean var2);

    public abstract CompileScope createModulesCompileScope(Module[] var1, boolean var2, boolean var3);

    public abstract CompileScope createModuleGroupCompileScope(Project var1, Module[] var2, boolean var3);

    public abstract CompileScope createProjectCompileScope(Project var1);

    public abstract void setValidationEnabled(ModuleType var1, boolean var2);

    public abstract boolean isValidationEnabled(Module var1);
}

