/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.BaseActionRunnable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.PsiFile;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.SwingUtilities;

public abstract class WriteCommandAction<T>
extends BaseActionRunnable<T> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.command.WriteCommandAction");
    private final String myCommandName;
    private final String myGroupID;
    private final Project myProject;
    private final PsiFile[] myPsiFiles;

    protected WriteCommandAction(Project project, PsiFile ... files) {
        this(project, "Undefined", files);
    }

    protected WriteCommandAction(Project project, String commandName, PsiFile ... files) {
        this(project, commandName, (String)null, files);
    }

    protected WriteCommandAction(Project project, String commandName, String groupID, PsiFile ... files) {
        this.myCommandName = commandName;
        this.myGroupID = groupID;
        this.myProject = project;
        this.myPsiFiles = files == null || files.length == 0 ? PsiFile.EMPTY_ARRAY : files;
    }

    public final Project getProject() {
        return this.myProject;
    }

    public final String getCommandName() {
        return this.myCommandName;
    }

    public String getGroupID() {
        return this.myGroupID;
    }

    @Override
    public RunResult<T> execute() {
        Application application = ApplicationManager.getApplication();
        if (!application.isDispatchThread() && application.isReadAccessAllowed()) {
            LOG.error("Must not start write action from within read action in the other thread - deadlock is coming");
        }
        final RunResult result = new RunResult(this);
        try {
            if (application.isDispatchThread()) {
                this.performWriteCommandAction(result);
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        WriteCommandAction.this.performWriteCommandAction(result);
                    }
                });
            }
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return result;
    }

    public static boolean ensureFilesWritable(Project project, Collection<PsiFile> psiFiles) {
        return FileModificationService.getInstance().preparePsiElementsForWrite(psiFiles);
    }

    private void performWriteCommandAction(RunResult<T> result) {
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(Arrays.asList(this.myPsiFiles))) {
            return;
        }
        final RunResult[] results = new RunResult[]{result};
        CommandProcessor.getInstance().executeCommand(this.getProject(), new Runnable(){

            @Override
            public void run() {
                WriteCommandAction.this.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        results[0].run();
                        results[0] = null;
                    }
                });
            }
        }, this.getCommandName(), (Object)this.getGroupID(), this.getUndoConfirmationPolicy());
    }

    protected boolean isGlobalUndoAction() {
        return false;
    }

    protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
        return UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION;
    }

    public void performCommand() throws Throwable {
        final RunResult[] results = new RunResult[]{new RunResult(this)};
        final Ref exception = new Ref();
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                if (WriteCommandAction.this.isGlobalUndoAction()) {
                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(WriteCommandAction.this.myProject);
                }
                exception.set((Object)results[0].run().getThrowable());
                results[0] = null;
            }
        }, this.getCommandName(), (Object)this.getGroupID(), this.getUndoConfirmationPolicy());
        Throwable throwable = (Throwable)exception.get();
        if (throwable != null) {
            throw throwable;
        }
    }

    public static void runWriteCommandAction(Project project, final Runnable runnable) {
        new Simple(project, new PsiFile[0]){

            @Override
            protected void run() throws Throwable {
                runnable.run();
            }
        }.execute();
    }

    public static <T> T runWriteCommandAction(Project project, final Computable<T> computable) {
        return new WriteCommandAction<T>(project, new PsiFile[0]){

            @Override
            protected void run(Result<T> result) throws Throwable {
                result.setResult(computable.compute());
            }
        }.execute().getResultObject();
    }

    public static <T, E extends Throwable> T runWriteCommandAction(Project project, final ThrowableComputable<T, E> computable) throws E {
        RunResult<T> result = new WriteCommandAction<T>(project, "", new PsiFile[0]){

            @Override
            protected void run(Result<T> result) throws Throwable {
                result.setResult(computable.compute());
            }
        }.execute();
        if (result.getThrowable() instanceof Throwable) {
            throw result.getThrowable();
        }
        return result.throwException().getResultObject();
    }

    public static abstract class Simple<T>
    extends WriteCommandAction<T> {
        protected Simple(Project project, PsiFile ... files) {
            super(project, files);
        }

        protected Simple(Project project, String commandName, PsiFile ... files) {
            super(project, commandName, files);
        }

        protected Simple(Project project, String name, String groupID, PsiFile ... files) {
            super(project, name, groupID, files);
        }

        @Override
        protected void run(Result<T> result) throws Throwable {
            this.run();
        }

        protected abstract void run() throws Throwable;
    }
}

