/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.CachedSingletonsRegistry;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;

public class ApplicationManager {
    protected static Application ourApplication = null;

    public static Application getApplication() {
        return ourApplication;
    }

    private static void setApplication(Application instance) {
        ourApplication = instance;
        CachedSingletonsRegistry.cleanupCachedFields();
    }

    public static void setApplication(Application instance, Disposable parent) {
        final Application old = ourApplication;
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                if (old != null) {
                    ApplicationManager.setApplication(old);
                }
            }
        });
        ApplicationManager.setApplication(instance);
    }

    public static void setApplication(Application instance, Getter<FileTypeRegistry> fileTypeRegistryGetter, Disposable parent) {
        final Application old = ourApplication;
        final Getter<FileTypeRegistry> oldFileTypeRegistry = FileTypeRegistry.ourInstanceGetter;
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                if (old != null) {
                    ApplicationManager.setApplication(old);
                    FileTypeRegistry.ourInstanceGetter = oldFileTypeRegistry;
                }
            }
        });
        ApplicationManager.setApplication(instance);
        FileTypeRegistry.ourInstanceGetter = fileTypeRegistryGetter;
    }
}

