/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.ide.ui.UISettings;
import gnu.trove.THashMap;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Map;
import javax.swing.Icon;

public final class Presentation
implements Cloneable {
    private Map<String, Object> myUserMap;
    public static final String PROP_TEXT = "text";
    public static final String PROP_MNEMONIC_KEY = "mnemonicKey";
    public static final String PROP_MNEMONIC_INDEX = "mnemonicIndex";
    public static final String PROP_DESCRIPTION = "description";
    public static final String PROP_ICON = "icon";
    public static final String PROP_DISABLED_ICON = "disabledIcon";
    public static final String PROP_SELECTED_ICON = "selectedIcon";
    public static final String PROP_HOVERED_ICON = "hoveredIcon";
    public static final String PROP_VISIBLE = "visible";
    public static final String PROP_ENABLED = "enabled";
    public static final double DEFAULT_WEIGHT = 0.0;
    public static final double HIGHER_WEIGHT = 42.0;
    public static final double EVEN_HIGHER_WEIGHT = 239.0;
    private PropertyChangeSupport myChangeSupport = new PropertyChangeSupport(this);
    private String myText;
    private String myDescription;
    private Icon myIcon;
    private Icon myDisabledIcon;
    private Icon myHoveredIcon;
    private Icon mySelectedIcon;
    private int myMnemonic;
    private int myDisplayedMnemonicIndex = -1;
    private boolean myVisible = true;
    private boolean myEnabled = true;
    private double myWeight = 0.0;

    public Presentation() {
    }

    public Presentation(String text) {
        this();
        this.myText = text;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.myChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.myChangeSupport.removePropertyChangeListener(l);
    }

    public String getText() {
        return this.myText;
    }

    public void setText(String text, boolean mayContainMnemonic) {
        int oldMnemonic = this.myMnemonic;
        int oldDisplayedMnemonicIndex = this.myDisplayedMnemonicIndex;
        String oldText = this.myText;
        this.myMnemonic = 0;
        this.myDisplayedMnemonicIndex = -1;
        if (text != null) {
            if (text.indexOf(27) >= 0) {
                text = text.replace('\u001b', '&');
            }
            if (mayContainMnemonic) {
                StringBuilder plainText = new StringBuilder();
                for (int i = 0; i < text.length(); ++i) {
                    char ch = text.charAt(i);
                    if (this.myMnemonic == 0 && (ch == '_' || ch == '&')) {
                        if (++i >= text.length()) break;
                        ch = text.charAt(i);
                        if (ch != '_' && ch != '&') {
                            if (UISettings.getInstance().DISABLE_MNEMONICS_IN_CONTROLS) {
                                this.myMnemonic = 0;
                                this.myDisplayedMnemonicIndex = -1;
                            } else {
                                this.myMnemonic = Character.toUpperCase(ch);
                                this.myDisplayedMnemonicIndex = i - 1;
                            }
                        }
                    }
                    plainText.append(ch);
                }
                this.myText = plainText.length() == 0 ? "" : plainText.toString();
            } else {
                this.myText = text.isEmpty() ? "" : text;
            }
        } else {
            this.myText = null;
        }
        this.myChangeSupport.firePropertyChange(PROP_TEXT, oldText, this.myText);
        if (this.myMnemonic != oldMnemonic) {
            this.myChangeSupport.firePropertyChange(PROP_MNEMONIC_KEY, new Integer(oldMnemonic), new Integer(this.myMnemonic));
        }
        if (this.myDisplayedMnemonicIndex != oldDisplayedMnemonicIndex) {
            this.myChangeSupport.firePropertyChange(PROP_MNEMONIC_INDEX, new Integer(oldDisplayedMnemonicIndex), new Integer(this.myDisplayedMnemonicIndex));
        }
    }

    public void setText(String text) {
        this.setText(text, true);
    }

    public String getTextWithMnemonic() {
        if (this.myText != null && this.myDisplayedMnemonicIndex > -1) {
            return this.myText.substring(0, this.myDisplayedMnemonicIndex) + "_" + this.myText.substring(this.myDisplayedMnemonicIndex);
        }
        return this.myText;
    }

    public void restoreTextWithMnemonic(Presentation presentation) {
        this.setText(presentation.getTextWithMnemonic());
    }

    public static String restoreTextWithMnemonic(String text, int mnemonic) {
        if (text == null) {
            return null;
        }
        for (int i = 0; i < text.length(); ++i) {
            if (Character.toUpperCase(text.charAt(i)) != mnemonic) continue;
            return text.substring(0, i) + "_" + text.substring(i);
        }
        return text;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String description) {
        String oldDescription = this.myDescription;
        this.myDescription = description;
        this.myChangeSupport.firePropertyChange(PROP_DESCRIPTION, oldDescription, this.myDescription);
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public void setIcon(Icon icon) {
        Icon oldIcon = this.myIcon;
        if (oldIcon == icon) {
            return;
        }
        this.myIcon = icon;
        this.myChangeSupport.firePropertyChange(PROP_ICON, oldIcon, this.myIcon);
    }

    public Icon getDisabledIcon() {
        return this.myDisabledIcon;
    }

    public void setDisabledIcon(Icon icon) {
        Icon oldDisabledIcon = this.myDisabledIcon;
        this.myDisabledIcon = icon;
        this.myChangeSupport.firePropertyChange(PROP_DISABLED_ICON, oldDisabledIcon, this.myDisabledIcon);
    }

    public Icon getHoveredIcon() {
        return this.myHoveredIcon;
    }

    public void setHoveredIcon(Icon hoveredIcon) {
        Icon old = this.myHoveredIcon;
        this.myHoveredIcon = hoveredIcon;
        this.myChangeSupport.firePropertyChange(PROP_HOVERED_ICON, old, this.myHoveredIcon);
    }

    public Icon getSelectedIcon() {
        return this.mySelectedIcon;
    }

    public void setSelectedIcon(Icon selectedIcon) {
        Icon old = this.mySelectedIcon;
        this.mySelectedIcon = selectedIcon;
        this.myChangeSupport.firePropertyChange(PROP_SELECTED_ICON, old, this.mySelectedIcon);
    }

    public int getMnemonic() {
        return this.myMnemonic;
    }

    public int getDisplayedMnemonicIndex() {
        return this.myDisplayedMnemonicIndex;
    }

    public boolean isVisible() {
        return this.myVisible;
    }

    public void setVisible(boolean visible) {
        boolean oldVisible = this.myVisible;
        this.myVisible = visible;
        this.firePropertyChange(PROP_VISIBLE, oldVisible ? Boolean.TRUE : Boolean.FALSE, this.myVisible ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        boolean oldEnabled = this.myEnabled;
        this.myEnabled = enabled;
        this.firePropertyChange(PROP_ENABLED, oldEnabled ? Boolean.TRUE : Boolean.FALSE, this.myEnabled ? Boolean.TRUE : Boolean.FALSE);
    }

    public final void setEnabledAndVisible(boolean enabled) {
        this.setEnabled(enabled);
        this.setVisible(enabled);
    }

    void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.myChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Presentation clone() {
        try {
            Presentation presentation = (Presentation)super.clone();
            presentation.myChangeSupport = new PropertyChangeSupport(presentation);
            return presentation;
        }
        catch (CloneNotSupportedException exc) {
            throw new RuntimeException(exc.getMessage());
        }
    }

    public void copyFrom(Presentation presentation) {
        this.setText(presentation.getTextWithMnemonic());
        this.setDescription(presentation.getDescription());
        this.setIcon(presentation.getIcon());
        this.setDisabledIcon(presentation.getDisabledIcon());
        this.setVisible(presentation.isVisible());
        this.setEnabled(presentation.isEnabled());
    }

    public Object getClientProperty(String key) {
        if (this.myUserMap == null) {
            return null;
        }
        return this.myUserMap.get(key);
    }

    public void putClientProperty(String key, Object value) {
        if (this.myUserMap == null) {
            this.myUserMap = new THashMap(1);
        }
        Object oldValue = this.myUserMap.put(key, value);
        this.myChangeSupport.firePropertyChange(key, oldValue, value);
    }

    public double getWeight() {
        return this.myWeight;
    }

    public void setWeight(double weight) {
        this.myWeight = weight;
    }

    public String toString() {
        return this.myText + " (" + this.myDescription + ")";
    }

    public boolean isEnabledAndVisible() {
        return this.isEnabled() && this.isVisible();
    }
}

