/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import javax.swing.KeyStroke;

public final class CustomShortcutSet
implements ShortcutSet {
    private final Shortcut[] myShortcuts;

    public CustomShortcutSet(KeyStroke keyStroke) {
        this(new KeyboardShortcut(keyStroke, null));
    }

    public CustomShortcutSet() {
        this.myShortcuts = Shortcut.EMPTY_ARRAY;
    }

    public CustomShortcutSet(Shortcut ... shortcuts) {
        this.myShortcuts = shortcuts.length == 0 ? Shortcut.EMPTY_ARRAY : (Shortcut[])shortcuts.clone();
    }

    public CustomShortcutSet(Integer ... keyCodes) {
        this.myShortcuts = (Shortcut[])ContainerUtil.map((Object[])keyCodes, (Function)new Function<Integer, Shortcut>(){

            public Shortcut fun(Integer integer) {
                return new KeyboardShortcut(KeyStroke.getKeyStroke(integer, 0), null);
            }
        }, (Object[])Shortcut.EMPTY_ARRAY);
    }

    @Override
    public Shortcut[] getShortcuts() {
        return this.myShortcuts.length == 0 ? Shortcut.EMPTY_ARRAY : (Shortcut[])this.myShortcuts.clone();
    }

    public static CustomShortcutSet fromString(String ... keyboardShortcuts) {
        Shortcut[] shortcuts = new KeyboardShortcut[keyboardShortcuts.length];
        for (int i = 0; i < keyboardShortcuts.length; ++i) {
            shortcuts[i] = KeyboardShortcut.fromString(keyboardShortcuts[i]);
        }
        return new CustomShortcutSet(shortcuts);
    }
}

