/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.SmartList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.intellij.lang.annotations.JdkConstants;

public abstract class AnAction
implements PossiblyDumbAware {
    public static final AnAction[] EMPTY_ARRAY = new AnAction[0];
    public static final String ourClientProperty = "AnAction.shortcutSet";
    private Presentation myTemplatePresentation;
    private ShortcutSet myShortcutSet = ourEmptyShortcutSet;
    private boolean myEnabledInModalContext = false;
    private static final ShortcutSet ourEmptyShortcutSet = new CustomShortcutSet();
    private boolean myIsDefaultIcon = true;
    private boolean myWorksInInjected;

    public AnAction() {
        this(null, null, null);
    }

    public AnAction(Icon icon) {
        this(null, null, icon);
    }

    public AnAction(String text) {
        this(text, null, null);
    }

    public AnAction(String text, String description, Icon icon) {
        Presentation presentation = this.getTemplatePresentation();
        presentation.setText(text);
        presentation.setDescription(description);
        presentation.setIcon(icon);
    }

    public final ShortcutSet getShortcutSet() {
        return this.myShortcutSet;
    }

    public final void registerCustomShortcutSet(ShortcutSet shortcutSet, JComponent component) {
        this.myShortcutSet = shortcutSet;
        if (component != null) {
            List actionList = (List)component.getClientProperty(ourClientProperty);
            if (actionList == null) {
                actionList = new SmartList();
                component.putClientProperty(ourClientProperty, actionList);
            }
            if (!actionList.contains(this)) {
                actionList.add(this);
            }
        }
    }

    public final void registerCustomShortcutSet(int keyCode, @JdkConstants.InputEventMask int modifiers, JComponent component) {
        this.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(keyCode, modifiers)), component);
    }

    public final void registerCustomShortcutSet(ShortcutSet shortcutSet, final JComponent component, Disposable parentDisposable) {
        this.registerCustomShortcutSet(shortcutSet, component);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                AnAction.this.unregisterCustomShortcutSet(component);
            }
        });
    }

    public final void unregisterCustomShortcutSet(JComponent component) {
        List actionList;
        if (component != null && (actionList = (List)component.getClientProperty(ourClientProperty)) != null) {
            actionList.remove(this);
        }
    }

    public final void copyFrom(AnAction sourceAction) {
        Presentation sourcePresentation = sourceAction.getTemplatePresentation();
        Presentation presentation = this.getTemplatePresentation();
        presentation.setIcon(sourcePresentation.getIcon());
        presentation.setText(sourcePresentation.getTextWithMnemonic());
        presentation.setDescription(sourcePresentation.getDescription());
        this.copyShortcutFrom(sourceAction);
    }

    public final void copyShortcutFrom(AnAction sourceAction) {
        this.myShortcutSet = sourceAction.myShortcutSet;
    }

    public final boolean isEnabledInModalContext() {
        return this.myEnabledInModalContext;
    }

    protected final void setEnabledInModalContext(boolean enabledInModalContext) {
        this.myEnabledInModalContext = enabledInModalContext;
    }

    public boolean displayTextInToolbar() {
        return false;
    }

    public void update(AnActionEvent e) {
    }

    public void beforeActionPerformedUpdate(AnActionEvent e) {
        boolean worksInInjected = this.isInInjectedContext();
        e.setInjectedContext(worksInInjected);
        this.update(e);
        if (!e.getPresentation().isEnabled() && worksInInjected) {
            e.setInjectedContext(false);
            this.update(e);
        }
    }

    public final Presentation getTemplatePresentation() {
        Presentation presentation = this.myTemplatePresentation;
        if (presentation == null) {
            this.myTemplatePresentation = presentation = new Presentation();
        }
        return presentation;
    }

    public abstract void actionPerformed(AnActionEvent var1);

    protected void setShortcutSet(ShortcutSet shortcutSet) {
        this.myShortcutSet = shortcutSet;
    }

    public void setDefaultIcon(boolean isDefaultIconSet) {
        this.myIsDefaultIcon = isDefaultIconSet;
    }

    public boolean isDefaultIcon() {
        return this.myIsDefaultIcon;
    }

    public void setInjectedContext(boolean worksInInjected) {
        this.myWorksInInjected = worksInInjected;
    }

    public boolean isInInjectedContext() {
        return this.myWorksInInjected;
    }

    public boolean isTransparentUpdate() {
        return this instanceof TransparentUpdate;
    }

    @Override
    public boolean isDumbAware() {
        return this instanceof DumbAware;
    }

    public static Project getEventProject(AnActionEvent e) {
        return e == null ? null : e.getData(CommonDataKeys.PROJECT);
    }

    public String toString() {
        return this.getTemplatePresentation().toString();
    }

    public static interface TransparentUpdate {
    }
}

