/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;

public class ActionStub
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.actionSystem.ActionStub");
    private final String myClassName;
    private final String myProjectType;
    private final String myId;
    private final String myText;
    private final ClassLoader myLoader;
    private final PluginId myPluginId;
    private final String myIconPath;

    public ActionStub(String actionClass, String id, String text, ClassLoader loader, PluginId pluginId, String iconPath, String projectType) {
        this.myLoader = loader;
        this.myClassName = actionClass;
        this.myProjectType = projectType;
        LOG.assertTrue(!id.isEmpty());
        this.myId = id;
        this.myText = text;
        this.myPluginId = pluginId;
        this.myIconPath = iconPath;
    }

    public String getClassName() {
        return this.myClassName;
    }

    public String getId() {
        return this.myId;
    }

    public String getText() {
        return this.myText;
    }

    public ClassLoader getLoader() {
        return this.myLoader;
    }

    public PluginId getPluginId() {
        return this.myPluginId;
    }

    public String getIconPath() {
        return this.myIconPath;
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        throw new UnsupportedOperationException();
    }

    public final void initAction(AnAction targetAction) {
        Presentation sourcePresentation = this.getTemplatePresentation();
        Presentation targetPresentation = targetAction.getTemplatePresentation();
        if (targetPresentation.getIcon() == null && sourcePresentation.getIcon() != null) {
            targetPresentation.setIcon(sourcePresentation.getIcon());
        }
        if (targetPresentation.getText() == null && sourcePresentation.getText() != null) {
            targetPresentation.setText(sourcePresentation.getText());
        }
        if (targetPresentation.getDescription() == null && sourcePresentation.getDescription() != null) {
            targetPresentation.setDescription(sourcePresentation.getDescription());
        }
        targetAction.setShortcutSet(this.getShortcutSet());
    }

    public String getProjectType() {
        return this.myProjectType;
    }
}

