/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.annotation;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAsIntentionAdapter;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;

public final class Annotation
implements Segment {
    private final int myStartOffset;
    private final int myEndOffset;
    private final HighlightSeverity mySeverity;
    private final String myMessage;
    private ProblemHighlightType myHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
    private TextAttributesKey myEnforcedAttributesKey;
    private TextAttributes myEnforcedAttributes;
    private List<QuickFixInfo> myQuickFixes = null;
    private Boolean myNeedsUpdateOnTyping = null;
    private String myTooltip;
    private boolean myAfterEndOfLine = false;
    private boolean myIsFileLevelAnnotation = false;
    private GutterIconRenderer myGutterIconRenderer;
    private ProblemGroup myProblemGroup;
    private List<QuickFixInfo> myBatchFixes;

    public Annotation(int startOffset, int endOffset, HighlightSeverity severity, String message, String tooltip) {
        assert (startOffset <= endOffset) : startOffset + ":" + endOffset;
        assert (startOffset >= 0) : "Start offset must not be negative: " + startOffset;
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myMessage = message;
        this.myTooltip = tooltip;
        this.mySeverity = severity;
    }

    public void registerFix(IntentionAction fix) {
        this.registerFix(fix, null);
    }

    public void registerFix(IntentionAction fix, TextRange range) {
        this.registerFix(fix, range, null);
    }

    public void registerFix(LocalQuickFix fix, TextRange range, HighlightDisplayKey key, ProblemDescriptor problemDescriptor) {
        if (range == null) {
            range = new TextRange(this.myStartOffset, this.myEndOffset);
        }
        if (this.myQuickFixes == null) {
            this.myQuickFixes = new ArrayList<QuickFixInfo>();
        }
        this.myQuickFixes.add(new QuickFixInfo(new LocalQuickFixAsIntentionAdapter(fix, problemDescriptor), range, key));
    }

    public void registerFix(IntentionAction fix, TextRange range, HighlightDisplayKey key) {
        if (range == null) {
            range = new TextRange(this.myStartOffset, this.myEndOffset);
        }
        if (this.myQuickFixes == null) {
            this.myQuickFixes = new ArrayList<QuickFixInfo>();
        }
        this.myQuickFixes.add(new QuickFixInfo(fix, range, key));
    }

    public <T extends IntentionAction & LocalQuickFix> void registerBatchFix(T fix, TextRange range, HighlightDisplayKey key) {
        if (range == null) {
            range = new TextRange(this.myStartOffset, this.myEndOffset);
        }
        if (this.myBatchFixes == null) {
            this.myBatchFixes = new ArrayList<QuickFixInfo>();
        }
        this.myBatchFixes.add(new QuickFixInfo(fix, range, key));
    }

    public <T extends IntentionAction & LocalQuickFix> void registerUniversalFix(T fix, TextRange range, HighlightDisplayKey key) {
        this.registerBatchFix(fix, range, key);
        this.registerFix(fix, range, key);
    }

    public void setNeedsUpdateOnTyping(boolean b) {
        this.myNeedsUpdateOnTyping = b;
    }

    public boolean needsUpdateOnTyping() {
        if (this.myNeedsUpdateOnTyping == null) {
            return this.mySeverity != HighlightSeverity.INFORMATION;
        }
        return this.myNeedsUpdateOnTyping;
    }

    public int getStartOffset() {
        return this.myStartOffset;
    }

    public int getEndOffset() {
        return this.myEndOffset;
    }

    public HighlightSeverity getSeverity() {
        return this.mySeverity;
    }

    public ProblemHighlightType getHighlightType() {
        return this.myHighlightType;
    }

    public TextAttributesKey getTextAttributes() {
        if (this.myEnforcedAttributesKey != null) {
            return this.myEnforcedAttributesKey;
        }
        if (this.myHighlightType == ProblemHighlightType.GENERIC_ERROR_OR_WARNING) {
            if (this.mySeverity == HighlightSeverity.ERROR) {
                return CodeInsightColors.ERRORS_ATTRIBUTES;
            }
            if (this.mySeverity == HighlightSeverity.WARNING) {
                return CodeInsightColors.WARNINGS_ATTRIBUTES;
            }
            if (this.mySeverity == HighlightSeverity.WEAK_WARNING) {
                return CodeInsightColors.WEAK_WARNING_ATTRIBUTES;
            }
        }
        if (this.myHighlightType == ProblemHighlightType.GENERIC_ERROR) {
            return CodeInsightColors.ERRORS_ATTRIBUTES;
        }
        if (this.myHighlightType == ProblemHighlightType.LIKE_DEPRECATED) {
            return CodeInsightColors.DEPRECATED_ATTRIBUTES;
        }
        if (this.myHighlightType == ProblemHighlightType.LIKE_UNUSED_SYMBOL) {
            return CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES;
        }
        if (this.myHighlightType == ProblemHighlightType.LIKE_UNKNOWN_SYMBOL || this.myHighlightType == ProblemHighlightType.ERROR) {
            return CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES;
        }
        return HighlighterColors.TEXT;
    }

    public TextAttributes getEnforcedTextAttributes() {
        return this.myEnforcedAttributes;
    }

    public void setEnforcedTextAttributes(TextAttributes enforcedAttributes) {
        this.myEnforcedAttributes = enforcedAttributes;
    }

    public List<QuickFixInfo> getQuickFixes() {
        return this.myQuickFixes;
    }

    public List<QuickFixInfo> getBatchFixes() {
        return this.myBatchFixes;
    }

    public String getMessage() {
        return this.myMessage;
    }

    public String getTooltip() {
        return this.myTooltip;
    }

    public void setTooltip(String tooltip) {
        this.myTooltip = tooltip;
    }

    public void setHighlightType(ProblemHighlightType highlightType) {
        this.myHighlightType = highlightType;
    }

    public void setTextAttributes(TextAttributesKey enforcedAttributes) {
        this.myEnforcedAttributesKey = enforcedAttributes;
    }

    public boolean isAfterEndOfLine() {
        return this.myAfterEndOfLine;
    }

    public void setAfterEndOfLine(boolean afterEndOfLine) {
        this.myAfterEndOfLine = afterEndOfLine;
    }

    public boolean isFileLevelAnnotation() {
        return this.myIsFileLevelAnnotation;
    }

    public void setFileLevelAnnotation(boolean isFileLevelAnnotation) {
        this.myIsFileLevelAnnotation = isFileLevelAnnotation;
    }

    public GutterIconRenderer getGutterIconRenderer() {
        return this.myGutterIconRenderer;
    }

    public void setGutterIconRenderer(GutterIconRenderer gutterIconRenderer) {
        this.myGutterIconRenderer = gutterIconRenderer;
    }

    public ProblemGroup getProblemGroup() {
        return this.myProblemGroup;
    }

    public void setProblemGroup(ProblemGroup problemGroup) {
        this.myProblemGroup = problemGroup;
    }

    public String toString() {
        return "Annotation(message='" + this.myMessage + "'" + ", severity='" + this.mySeverity + "'" + ", toolTip='" + this.myTooltip + "'" + ")";
    }

    public static class QuickFixInfo {
        public final IntentionAction quickFix;
        public final TextRange textRange;
        public final HighlightDisplayKey key;

        public QuickFixInfo(IntentionAction fix, TextRange range, HighlightDisplayKey key) {
            this.key = key;
            this.quickFix = fix;
            this.textRange = range;
        }

        public String toString() {
            return this.quickFix.toString();
        }
    }
}

