/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.DependentLanguage;
import com.intellij.lang.InjectableLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public final class LanguageUtil {
    public static final Comparator<Language> LANGUAGE_COMPARATOR = new Comparator<Language>(){

        @Override
        public int compare(Language o1, Language o2) {
            return o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
        }
    };

    private LanguageUtil() {
    }

    public static ParserDefinition.SpaceRequirements canStickTokensTogetherByLexer(ASTNode left, ASTNode right, Lexer lexer) {
        String textStr = left.getText() + right.getText();
        lexer.start(textStr, 0, textStr.length());
        if (lexer.getTokenType() != left.getElementType()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        if (lexer.getTokenEnd() != left.getTextLength()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        lexer.advance();
        if (lexer.getTokenEnd() != textStr.length()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        if (lexer.getTokenType() != right.getElementType()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        return ParserDefinition.SpaceRequirements.MAY;
    }

    public static Language[] getLanguageDialects(final Language base) {
        List list = ContainerUtil.findAll(Language.getRegisteredLanguages(), (Condition)new Condition<Language>(){

            public boolean value(Language language) {
                return language.getBaseLanguage() == base;
            }
        });
        return list.toArray(new Language[list.size()]);
    }

    public static boolean isInTemplateLanguageFile(PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        Language language = psiFile.getViewProvider().getBaseLanguage();
        return language instanceof TemplateLanguage;
    }

    public static boolean isInjectableLanguage(Language language) {
        if (language == Language.ANY) {
            return false;
        }
        if (language.getID().startsWith("$")) {
            return false;
        }
        if (language instanceof InjectableLanguage) {
            return true;
        }
        if (language instanceof TemplateLanguage || language instanceof DependentLanguage) {
            return false;
        }
        return LanguageParserDefinitions.INSTANCE.forLanguage(language) != null;
    }

    public static boolean isFileLanguage(Language language) {
        if (language instanceof DependentLanguage || language instanceof InjectableLanguage) {
            return false;
        }
        if (LanguageParserDefinitions.INSTANCE.forLanguage(language) == null) {
            return false;
        }
        LanguageFileType type = language.getAssociatedFileType();
        if (type == null || StringUtil.isEmpty((String)type.getDefaultExtension())) {
            return false;
        }
        String name = language.getDisplayName();
        if (StringUtil.isEmpty((String)name) || name.startsWith("<") || name.startsWith("[")) {
            return false;
        }
        return StringUtil.isNotEmpty((String)type.getDefaultExtension());
    }

    public static List<Language> getFileLanguages() {
        ArrayList result = ContainerUtil.newArrayList();
        for (Language language : Language.getRegisteredLanguages()) {
            if (!LanguageUtil.isFileLanguage(language)) continue;
            result.add(language);
        }
        Collections.sort(result, LANGUAGE_COMPARATOR);
        return result;
    }

    public static Language getRootLanguage(PsiElement element) {
        FileViewProvider provider = element.getContainingFile().getViewProvider();
        Set<Language> languages = provider.getLanguages();
        if (languages.size() > 1) {
            for (PsiElement current = element; current != null; current = current.getParent()) {
                Language language = current.getLanguage();
                if (!languages.contains((Object)language)) continue;
                return language;
            }
        }
        return provider.getBaseLanguage();
    }
}

