/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.Language;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyedExtensionCollector;
import java.util.List;

public class LanguageExtension<T>
extends KeyedExtensionCollector<T, Language> {
    private final T myDefaultImplementation;
    private final Key<T> IN_LANGUAGE_CACHE;

    public LanguageExtension(String epName) {
        this(epName, null);
    }

    public LanguageExtension(String epName, T defaultImplementation) {
        super(epName);
        this.myDefaultImplementation = defaultImplementation;
        this.IN_LANGUAGE_CACHE = Key.create((String)("EXTENSIONS_IN_LANGUAGE_" + epName));
    }

    @Override
    protected String keyToString(Language key) {
        return key.getID();
    }

    public T forLanguage(Language l) {
        Language base;
        Object cached = l.getUserData(this.IN_LANGUAGE_CACHE);
        if (cached != null) {
            return (T)cached;
        }
        List extensions = this.forKey(l);
        Object result = extensions.isEmpty() ? ((base = l.getBaseLanguage()) == null ? this.myDefaultImplementation : this.forLanguage(base)) : extensions.get(0);
        if (result == null) {
            return null;
        }
        result = l.putUserDataIfAbsent(this.IN_LANGUAGE_CACHE, result);
        return result;
    }

    public List<T> allForLanguage(Language l) {
        Language base;
        List list = this.forKey(l);
        if (list.isEmpty() && (base = l.getBaseLanguage()) != null) {
            return this.allForLanguage(base);
        }
        return list;
    }

    protected T getDefaultImplementation() {
        return this.myDefaultImplementation;
    }

    protected Key<T> getLanguageCache() {
        return this.IN_LANGUAGE_CACHE;
    }
}

