/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public abstract class Language
extends UserDataHolderBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.Language");
    private static final Map<Class<? extends Language>, Language> ourRegisteredLanguages = ContainerUtil.newConcurrentMap();
    private static final ConcurrentMap<String, List<Language>> ourRegisteredMimeTypes = ContainerUtil.newConcurrentMap();
    private static final Map<String, Language> ourRegisteredIDs = ContainerUtil.newConcurrentMap();
    private final Language myBaseLanguage;
    private final String myID;
    private final String[] myMimeTypes;
    private final List<Language> myDialects = ContainerUtil.createLockFreeCopyOnWriteList();
    public static final Language ANY = new Language(""){

        @Override
        public String toString() {
            return "Language: ANY";
        }
    };

    protected Language(String id) {
        this(id, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    protected Language(String ID2, String ... mimeTypes) {
        this((Language)null, ID2, mimeTypes);
    }

    protected Language(Language baseLanguage, String ID2, String ... mimeTypes) {
        this.myBaseLanguage = baseLanguage;
        this.myID = ID2;
        this.myMimeTypes = mimeTypes;
        Class<?> langClass = ((Object)((Object)this)).getClass();
        Language prev = ourRegisteredLanguages.put(langClass, this);
        if (prev != null) {
            LOG.error("Language of '" + langClass + "' is already registered: " + (Object)((Object)prev));
            return;
        }
        prev = ourRegisteredIDs.put(ID2, this);
        if (prev != null) {
            LOG.error("Language with ID '" + ID2 + "' is already registered: " + ((Object)((Object)prev)).getClass());
        }
        for (String mimeType : mimeTypes) {
            if (StringUtil.isEmpty((String)mimeType)) continue;
            List languagesByMimeType = (List)ourRegisteredMimeTypes.get(mimeType);
            if (languagesByMimeType == null) {
                languagesByMimeType = (List)ConcurrencyUtil.cacheOrGet(ourRegisteredMimeTypes, (Object)mimeType, (Object)ContainerUtil.createConcurrentList());
            }
            languagesByMimeType.add(this);
        }
        if (baseLanguage != null) {
            baseLanguage.myDialects.add(this);
        }
    }

    public static Collection<Language> getRegisteredLanguages() {
        Collection<Language> languages = ourRegisteredLanguages.values();
        return Collections.unmodifiableCollection(new ArrayList<Language>(languages));
    }

    public static <T extends Language> T findInstance(Class<T> klass) {
        return (T)((Object)ourRegisteredLanguages.get(klass));
    }

    public static Collection<Language> findInstancesByMimeType(String mimeType) {
        List result = mimeType == null ? null : (List)ourRegisteredMimeTypes.get(mimeType);
        return result == null ? Collections.emptyList() : Collections.unmodifiableCollection(result);
    }

    public String toString() {
        return "Language: " + this.myID;
    }

    public String[] getMimeTypes() {
        return this.myMimeTypes;
    }

    public String getID() {
        return this.myID;
    }

    public LanguageFileType getAssociatedFileType() {
        FileType[] types;
        for (FileType fileType : types = FileTypeRegistry.getInstance().getRegisteredFileTypes()) {
            if (!(fileType instanceof LanguageFileType) || ((LanguageFileType)fileType).getLanguage() != this) continue;
            return (LanguageFileType)fileType;
        }
        for (FileType fileType : types) {
            if (!(fileType instanceof LanguageFileType) || !this.isKindOf(((LanguageFileType)fileType).getLanguage())) continue;
            return (LanguageFileType)fileType;
        }
        return null;
    }

    public Language getBaseLanguage() {
        return this.myBaseLanguage;
    }

    public String getDisplayName() {
        return this.getID();
    }

    public final boolean is(Language another) {
        return this == another;
    }

    public boolean isCaseSensitive() {
        return this.myBaseLanguage != null && this.myBaseLanguage.isCaseSensitive();
    }

    public final boolean isKindOf(Language another) {
        for (Language l = this; l != null; l = l.getBaseLanguage()) {
            if (!l.is(another)) continue;
            return true;
        }
        return false;
    }

    public final boolean isKindOf(String anotherLanguageId) {
        for (Language l = this; l != null; l = l.getBaseLanguage()) {
            if (!l.getID().equals(anotherLanguageId)) continue;
            return true;
        }
        return false;
    }

    public List<Language> getDialects() {
        return this.myDialects;
    }

    public static Language findLanguageByID(String id) {
        return id == null ? null : ourRegisteredIDs.get(id);
    }

    protected Language(String id, boolean register) {
        this.myID = id;
        this.myBaseLanguage = null;
        this.myMimeTypes = null;
    }
}

