/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.ExternalAnnotatorsFilter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;

public class ExternalLanguageAnnotators
extends LanguageExtension<ExternalAnnotator> {
    public static final ExternalLanguageAnnotators INSTANCE = new ExternalLanguageAnnotators();

    private ExternalLanguageAnnotators() {
        super("com.intellij.externalAnnotator");
    }

    public static List<ExternalAnnotator> allForFile(Language language, final PsiFile file) {
        List annotators = INSTANCE.allForLanguage(language);
        final ExternalAnnotatorsFilter[] filters = (ExternalAnnotatorsFilter[])Extensions.getExtensions(ExternalAnnotatorsFilter.EXTENSION_POINT_NAME);
        return ContainerUtil.findAll(annotators, (Condition)new Condition<ExternalAnnotator>(){

            public boolean value(ExternalAnnotator annotator) {
                for (ExternalAnnotatorsFilter filter : filters) {
                    if (!filter.isProhibited(annotator, file)) continue;
                    return false;
                }
                return true;
            }
        });
    }
}

