/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.SelectionRequest;
import com.intellij.ide.util.treeView.TreeRunnable;
import com.intellij.ide.util.treeView.TreeUpdatePass;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class AbstractTreeUpdater
implements Disposable,
Activatable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.treeView.AbstractTreeUpdater");
    private final LinkedList<TreeUpdatePass> myNodeQueue = new LinkedList();
    private final AbstractTreeBuilder myTreeBuilder;
    private final List<Runnable> myRunAfterUpdate = new ArrayList<Runnable>();
    private Runnable myRunBeforeUpdate;
    private final MergingUpdateQueue myUpdateQueue;
    private long myUpdateCount;
    private boolean myReleaseRequested;

    public AbstractTreeUpdater(AbstractTreeBuilder treeBuilder) {
        this.myTreeBuilder = treeBuilder;
        JTree tree = this.myTreeBuilder.getTree();
        JTree component = tree instanceof TreeTableTree ? ((TreeTableTree)tree).getTreeTable() : tree;
        this.myUpdateQueue = new MergingUpdateQueue("UpdateQueue", 300, component.isShowing(), component){

            @Override
            protected Alarm createAlarm(Alarm.ThreadToUse thread, Disposable parent) {
                return new Alarm(thread, parent){

                    @Override
                    protected boolean isEdt() {
                        return AbstractTreeUpdater.this.isEdt();
                    }
                };
            }
        };
        this.myUpdateQueue.setRestartTimerOnAdd(false);
        UiNotifyConnector uiNotifyConnector = new UiNotifyConnector(component, this.myUpdateQueue);
        Disposer.register((Disposable)this, (Disposable)this.myUpdateQueue);
        Disposer.register((Disposable)this, (Disposable)uiNotifyConnector);
    }

    public void setDelay(int delay) {
        this.myUpdateQueue.setMergingTimeSpan(delay);
    }

    public void setPassThroughMode(boolean passThroughMode) {
        this.myUpdateQueue.setPassThrough(passThroughMode);
    }

    public void setModalityStateComponent(JComponent c) {
        this.myUpdateQueue.setModalityStateComponent(c);
    }

    public ModalityState getModalityState() {
        return this.myUpdateQueue.getModalityState();
    }

    public boolean hasNodesToUpdate() {
        return !this.myNodeQueue.isEmpty() || !this.myUpdateQueue.isEmpty();
    }

    public void dispose() {
    }

    public synchronized void addSubtreeToUpdate(DefaultMutableTreeNode rootNode) {
        this.addSubtreeToUpdate(new TreeUpdatePass(rootNode).setUpdateStamp(-1L));
    }

    public synchronized void requeue(TreeUpdatePass toAdd) {
        this.addSubtreeToUpdate(toAdd.setUpdateStamp(-1L));
    }

    public synchronized void addSubtreeToUpdate(TreeUpdatePass toAdd) {
        long newUpdateCount;
        Object element;
        if (this.myReleaseRequested) {
            return;
        }
        assert (!toAdd.isExpired());
        AbstractTreeUi ui = this.myTreeBuilder.getUi();
        if (ui.isUpdatingChildrenNow(toAdd.getNode())) {
            toAdd.expire();
        } else {
            Iterator iterator = this.myNodeQueue.iterator();
            while (iterator.hasNext()) {
                TreeUpdatePass passInQueue = (TreeUpdatePass)iterator.next();
                if (toAdd.isUpdateStructure() != passInQueue.isUpdateStructure()) continue;
                if (passInQueue == toAdd) {
                    toAdd.expire();
                    break;
                }
                if (passInQueue.getNode() == toAdd.getNode()) {
                    toAdd.expire();
                    break;
                }
                if (toAdd.getNode().isNodeAncestor(passInQueue.getNode())) {
                    toAdd.expire();
                    break;
                }
                if (!passInQueue.getNode().isNodeAncestor(toAdd.getNode())) continue;
                iterator.remove();
                passInQueue.expire();
            }
        }
        if (toAdd.getUpdateStamp() >= 0L && !ui.isParentLoadingInBackground(element = ui.getElementFor(toAdd.getNode())) && !ui.isParentUpdatingChildrenNow(toAdd.getNode())) {
            toAdd.setUpdateStamp(-1L);
        }
        long l = newUpdateCount = toAdd.getUpdateStamp() == -1L ? this.myUpdateCount : this.myUpdateCount + 1L;
        if (!toAdd.isExpired()) {
            Collection<TreeUpdatePass> yielding = ui.getYeildingPasses();
            for (TreeUpdatePass eachYielding : yielding) {
                DefaultMutableTreeNode eachNode = eachYielding.getCurrentNode();
                if (eachNode == null || !eachNode.isNodeAncestor(toAdd.getNode())) continue;
                eachYielding.setUpdateStamp(newUpdateCount);
            }
        }
        if (toAdd.isExpired()) {
            this.reQueueViewUpdateIfNeeded();
            return;
        }
        this.myNodeQueue.add(toAdd);
        this.myTreeBuilder.getUi().addActivity();
        this.myUpdateCount = newUpdateCount;
        toAdd.setUpdateStamp(this.myUpdateCount);
        this.reQueueViewUpdate();
    }

    private void reQueueViewUpdateIfNeeded() {
        if (this.myUpdateQueue.isEmpty() && !this.myNodeQueue.isEmpty()) {
            this.reQueueViewUpdate();
        }
    }

    private void reQueueViewUpdate() {
        this.queue(new Update("ViewUpdate"){

            @Override
            public boolean isExpired() {
                return AbstractTreeUpdater.this.myTreeBuilder.isDisposed();
            }

            @Override
            public void run() {
                AbstractTreeStructure structure = AbstractTreeUpdater.this.myTreeBuilder.getTreeStructure();
                if (structure.hasSomethingToCommit()) {
                    structure.asyncCommit().doWhenDone(new TreeRunnable("AbstractTreeUpdater.reQueueViewUpdate"){

                        @Override
                        public void perform() {
                            AbstractTreeUpdater.this.reQueueViewUpdateIfNeeded();
                        }
                    });
                    return;
                }
                try {
                    AbstractTreeUpdater.this.performUpdate();
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    LOG.error(AbstractTreeUpdater.this.myTreeBuilder.getClass().getName(), (Throwable)e);
                }
            }
        });
    }

    private void queue(Update update) {
        if (this.isReleased()) {
            return;
        }
        this.myUpdateQueue.queue(update);
    }

    protected void updateSubtree(DefaultMutableTreeNode node) {
        this.myTreeBuilder.updateSubtree(node);
    }

    public synchronized void performUpdate() {
        if (this.myRunBeforeUpdate != null) {
            this.myRunBeforeUpdate.run();
            this.myRunBeforeUpdate = null;
        }
        while (!this.myNodeQueue.isEmpty() && !this.isInPostponeMode()) {
            final TreeUpdatePass eachPass = this.myNodeQueue.removeFirst();
            this.beforeUpdate(eachPass).doWhenDone(new TreeRunnable("AbstractTreeUpdater.performUpdate"){

                @Override
                public void perform() {
                    try {
                        AbstractTreeUpdater.this.myTreeBuilder.getUi().updateSubtreeNow(eachPass, false);
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        // empty catch block
                    }
                }
            });
        }
        if (this.isReleased()) {
            return;
        }
        this.myTreeBuilder.getUi().maybeReady();
        this.maybeRunAfterUpdate();
    }

    private void maybeRunAfterUpdate() {
        if (this.myRunAfterUpdate != null) {
            TreeRunnable runnable = new TreeRunnable("AbstractTreeUpdater.maybeRunAfterUpdate"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void perform() {
                    ArrayList runAfterUpdate = null;
                    List list = AbstractTreeUpdater.this.myRunAfterUpdate;
                    synchronized (list) {
                        if (!AbstractTreeUpdater.this.myRunAfterUpdate.isEmpty()) {
                            runAfterUpdate = new ArrayList(AbstractTreeUpdater.this.myRunAfterUpdate);
                            AbstractTreeUpdater.this.myRunAfterUpdate.clear();
                        }
                    }
                    if (runAfterUpdate != null) {
                        for (Runnable r : runAfterUpdate) {
                            r.run();
                        }
                    }
                }
            };
            this.myTreeBuilder.getReady(this).doWhenDone(runnable);
        }
    }

    private boolean isReleased() {
        return this.myTreeBuilder.getUi() == null;
    }

    protected ActionCallback beforeUpdate(TreeUpdatePass pass) {
        return new ActionCallback.Done();
    }

    public boolean addSubtreeToUpdateByElement(Object element) {
        return this.addSubtreeToUpdateByElement(element, false);
    }

    public boolean addSubtreeToUpdateByElement(Object element, boolean forceResort) {
        DefaultMutableTreeNode node = this.myTreeBuilder.getNodeForElement(element);
        if (node != null) {
            this.myTreeBuilder.queueUpdateFrom(element, forceResort);
            return true;
        }
        return false;
    }

    public synchronized void cancelAllRequests() {
        this.myNodeQueue.clear();
        this.myUpdateQueue.cancelAllUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAfterUpdate(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        List<Runnable> list = this.myRunAfterUpdate;
        synchronized (list) {
            this.myRunAfterUpdate.add(runnable);
        }
        this.maybeRunAfterUpdate();
    }

    public synchronized void runBeforeUpdate(Runnable runnable) {
        this.myRunBeforeUpdate = runnable;
    }

    public synchronized long getUpdateCount() {
        return this.myUpdateCount;
    }

    public boolean isRerunNeededFor(TreeUpdatePass pass) {
        return pass.getUpdateStamp() < this.getUpdateCount();
    }

    public boolean isInPostponeMode() {
        return !this.myUpdateQueue.isActive() && !this.myUpdateQueue.isPassThrough();
    }

    @Override
    public void showNotify() {
        this.myUpdateQueue.showNotify();
    }

    @Override
    public void hideNotify() {
        this.myUpdateQueue.hideNotify();
    }

    protected boolean isEdt() {
        return Alarm.isEventDispatchThread();
    }

    public synchronized String toString() {
        return "AbstractTreeUpdater updateCount=" + this.myUpdateCount + " queue=[" + this.myUpdateQueue.toString() + "] " + " nodeQueue=" + this.myNodeQueue;
    }

    public void flush() {
        this.myUpdateQueue.sendFlush();
    }

    public synchronized boolean isEnqueuedToUpdate(DefaultMutableTreeNode node) {
        for (TreeUpdatePass pass : this.myNodeQueue) {
            if (!pass.willUpdate(node)) continue;
            return true;
        }
        return false;
    }

    public final void queueSelection(final SelectionRequest request) {
        this.queue(new Update("UserSelection", 999){

            @Override
            public void run() {
                request.execute(AbstractTreeUpdater.this.myTreeBuilder.getUi());
            }

            @Override
            public boolean isExpired() {
                return AbstractTreeUpdater.this.myTreeBuilder.isDisposed();
            }

            @Override
            public void setRejected() {
                request.reject();
            }
        });
    }

    public synchronized void requestRelease() {
        this.myReleaseRequested = true;
        this.reset();
        this.myUpdateQueue.deactivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        TreeUpdatePass[] passes;
        AbstractTreeUpdater abstractTreeUpdater = this;
        synchronized (abstractTreeUpdater) {
            passes = this.myNodeQueue.toArray(new TreeUpdatePass[this.myNodeQueue.size()]);
            this.myNodeQueue.clear();
        }
        this.myUpdateQueue.cancelAllUpdates();
        for (TreeUpdatePass each : passes) {
            this.myTreeBuilder.getUi().addToCancelled(each.getNode());
        }
    }
}

