/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.dnd;

import com.intellij.ide.dnd.DnDTarget;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.StreamUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public interface DnDNativeTarget
extends DnDTarget {
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.dnd.DnDNativeTarget");
    public static final String EVENT_KEY = "DnDEvent";

    public static class EventInfo {
        DataFlavor[] myFlavors;
        Transferable myTransferable;
        private final Map<DataFlavor, String> myTexts = new HashMap<DataFlavor, String>();

        EventInfo(DataFlavor[] flavors, Transferable transferable) {
            this.myFlavors = flavors;
            this.myTransferable = transferable;
        }

        public DataFlavor[] getFlavors() {
            return this.myFlavors;
        }

        public String getTextForFlavor(DataFlavor flavor) {
            if (this.myTexts.containsKey(flavor)) {
                return this.myTexts.get(flavor);
            }
            try {
                String text = StreamUtil.readTextFrom((Reader)flavor.getReaderForText(this.myTransferable));
                this.myTexts.put(flavor, text);
                return text;
            }
            catch (Exception e) {
                this.myTexts.put(flavor, null);
                return null;
            }
        }

        public Transferable getTransferable() {
            return this.myTransferable;
        }
    }
}

