/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;

public abstract class ElementCreator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.ElementCreator");
    private final Project myProject;
    private final String myErrorTitle;

    protected ElementCreator(Project project, String errorTitle) {
        this.myProject = project;
        this.myErrorTitle = errorTitle;
    }

    protected abstract PsiElement[] create(String var1) throws Exception;

    protected abstract String getActionName(String var1);

    public PsiElement[] tryCreate(final String inputString) {
        if (inputString.length() == 0) {
            Messages.showMessageDialog(this.myProject, IdeBundle.message("error.name.should.be.specified", new Object[0]), CommonBundle.getErrorTitle(), Messages.getErrorIcon());
            return PsiElement.EMPTY_ARRAY;
        }
        final Exception[] exception = new Exception[1];
        final SmartPsiElementPointer[][] myCreatedElements = new SmartPsiElementPointer[][]{null};
        final String commandName = this.getActionName(inputString);
        new WriteCommandAction(this.myProject, commandName, new PsiFile[0]){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void run(Result result) throws Throwable {
                LocalHistoryAction action = LocalHistoryAction.NULL;
                try {
                    action = LocalHistory.getInstance().startAction(commandName);
                    PsiElement[] psiElements = ElementCreator.this.create(inputString);
                    myCreatedElements[0] = new SmartPsiElementPointer[psiElements.length];
                    SmartPointerManager manager = SmartPointerManager.getInstance(ElementCreator.this.myProject);
                    for (int i = 0; i < myCreatedElements[0].length; ++i) {
                        myCreatedElements[0][i] = manager.createSmartPsiElementPointer(psiElements[i]);
                    }
                }
                catch (Exception ex) {
                    exception[0] = ex;
                }
                finally {
                    action.finish();
                }
            }

            @Override
            protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
                return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
            }
        }.execute();
        if (exception[0] != null) {
            LOG.info((Throwable)exception[0]);
            String errorMessage = CreateElementActionBase.filterMessage(exception[0].getMessage());
            if (errorMessage == null || errorMessage.length() == 0) {
                errorMessage = exception[0].toString();
            }
            Messages.showMessageDialog(this.myProject, errorMessage, this.myErrorTitle, Messages.getErrorIcon());
            return PsiElement.EMPTY_ARRAY;
        }
        SmartList result = new SmartList();
        for (SmartPsiElementPointer pointer : myCreatedElements[0]) {
            ContainerUtil.addIfNotNull(pointer.getElement(), (Collection)result);
        }
        return PsiUtilCore.toPsiElementArray((Collection<? extends PsiElement>)result);
    }
}

