/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.formatting.Spacing;
import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.List;

public class SpacingBuilder {
    private final CommonCodeStyleSettings myCodeStyleSettings;
    private final List<SpacingRule> myRules = new ArrayList<SpacingRule>();

    @Deprecated
    public SpacingBuilder(CodeStyleSettings codeStyleSettings) {
        this.myCodeStyleSettings = codeStyleSettings;
    }

    public SpacingBuilder(CodeStyleSettings codeStyleSettings, Language language) {
        this.myCodeStyleSettings = codeStyleSettings.getCommonSettings(language);
    }

    public SpacingBuilder(CommonCodeStyleSettings languageCodeStyleSettings) {
        assert (languageCodeStyleSettings.getLanguage() != null) : "Only language code style settings are accepted (getLanguage() != null)";
        this.myCodeStyleSettings = languageCodeStyleSettings;
    }

    public RuleBuilder after(IElementType elementType) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(null, TokenSet.create(elementType), null)});
    }

    public RuleBuilder after(TokenSet tokenSet) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(null, tokenSet, null)});
    }

    public RuleBuilder afterInside(IElementType elementType, IElementType parentType) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(TokenSet.create(parentType), TokenSet.create(elementType), null)});
    }

    public RuleBuilder afterInside(IElementType elementType, TokenSet parentType) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(parentType, TokenSet.create(elementType), null)});
    }

    public RuleBuilder afterInside(TokenSet tokenSet, IElementType parentType) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(TokenSet.create(parentType), tokenSet, null)});
    }

    public RuleBuilder before(IElementType elementType) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(null, null, TokenSet.create(elementType))});
    }

    public RuleBuilder beforeInside(TokenSet tokenSet, IElementType parentType) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(TokenSet.create(parentType), null, tokenSet)});
    }

    public RuleBuilder beforeInside(IElementType elementType, IElementType parentType) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(TokenSet.create(parentType), null, TokenSet.create(elementType))});
    }

    public RuleBuilder beforeInside(IElementType elementType, TokenSet parentTypes) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(parentTypes, null, TokenSet.create(elementType))});
    }

    public RuleBuilder between(IElementType left, IElementType right) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(null, TokenSet.create(left), TokenSet.create(right))});
    }

    public RuleBuilder between(IElementType left, TokenSet rightSet) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(null, TokenSet.create(left), rightSet)});
    }

    public RuleBuilder between(TokenSet leftSet, IElementType right) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(null, leftSet, TokenSet.create(right))});
    }

    public RuleBuilder between(TokenSet leftType, TokenSet rightType) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(null, leftType, rightType)});
    }

    public RuleBuilder betweenInside(IElementType leftType, IElementType rightType, IElementType parentType) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(TokenSet.create(parentType), TokenSet.create(leftType), TokenSet.create(rightType))});
    }

    public RuleBuilder betweenInside(TokenSet leftSet, TokenSet rightSet, IElementType parentType) {
        return new RuleBuilder(new RuleCondition[]{new RuleCondition(TokenSet.create(parentType), leftSet, rightSet)});
    }

    public RuleBuilder withinPair(IElementType pairFirst, IElementType pairSecond) {
        RuleCondition before = new RuleCondition(null, TokenSet.create(pairFirst), null);
        RuleCondition after = new RuleCondition(null, null, TokenSet.create(pairSecond));
        return new RuleBuilder(new RuleCondition[]{before, after});
    }

    public RuleBuilder withinPairInside(IElementType pairFirst, IElementType pairSecond, IElementType parent) {
        TokenSet parentSet = TokenSet.create(parent);
        RuleCondition before = new RuleCondition(parentSet, TokenSet.create(pairFirst), null);
        RuleCondition after = new RuleCondition(parentSet, null, TokenSet.create(pairSecond));
        return new RuleBuilder(new RuleCondition[]{before, after});
    }

    public RuleBuilder around(IElementType elementType) {
        return this.around(TokenSet.create(elementType));
    }

    public RuleBuilder around(TokenSet tokenSet) {
        RuleCondition before = new RuleCondition(null, null, tokenSet);
        RuleCondition after = new RuleCondition(null, tokenSet, null);
        return new RuleBuilder(new RuleCondition[]{before, after});
    }

    public RuleBuilder aroundInside(TokenSet tokenSet, TokenSet parent) {
        RuleCondition before = new RuleCondition(parent, null, tokenSet);
        RuleCondition after = new RuleCondition(parent, tokenSet, null);
        return new RuleBuilder(new RuleCondition[]{before, after});
    }

    public RuleBuilder aroundInside(TokenSet tokenSet, IElementType parent) {
        RuleCondition before = new RuleCondition(TokenSet.create(parent), null, tokenSet);
        RuleCondition after = new RuleCondition(TokenSet.create(parent), tokenSet, null);
        return new RuleBuilder(new RuleCondition[]{before, after});
    }

    public RuleBuilder aroundInside(IElementType token, IElementType parent) {
        TokenSet tokenSet = TokenSet.create(token);
        RuleCondition before = new RuleCondition(TokenSet.create(parent), null, tokenSet);
        RuleCondition after = new RuleCondition(TokenSet.create(parent), tokenSet, null);
        return new RuleBuilder(new RuleCondition[]{before, after});
    }

    public RuleBuilder aroundInside(IElementType token, TokenSet parent) {
        TokenSet tokenSet = TokenSet.create(token);
        RuleCondition before = new RuleCondition(parent, null, tokenSet);
        RuleCondition after = new RuleCondition(parent, tokenSet, null);
        return new RuleBuilder(new RuleCondition[]{before, after});
    }

    public SpacingBuilder append(SpacingBuilder builder) {
        this.myRules.addAll(builder.myRules);
        return this;
    }

    public Spacing getSpacing(Block parent, Block child1, Block child2) {
        if (!(parent instanceof ASTBlock && child1 instanceof ASTBlock && child2 instanceof ASTBlock)) {
            return null;
        }
        IElementType parentType = ((ASTBlock)parent).getNode().getElementType();
        IElementType child1Type = ((ASTBlock)child1).getNode().getElementType();
        IElementType child2Type = ((ASTBlock)child2).getNode().getElementType();
        for (SpacingRule rule : this.myRules) {
            if (!rule.matches(parentType, child1Type, child2Type)) continue;
            return rule.createSpacing();
        }
        return null;
    }

    public class RuleBuilder {
        RuleCondition[] myConditions;

        private RuleBuilder(RuleCondition ... conditions) {
            this.myConditions = conditions;
        }

        public SpacingBuilder none() {
            return this.spaces(0);
        }

        public SpacingBuilder spaceIf(boolean option) {
            return this.spaces(option ? 1 : 0);
        }

        public SpacingBuilder spaces(int count) {
            for (RuleCondition condition : this.myConditions) {
                SpacingBuilder.this.myRules.add(new SpacingRule(condition, count, count, 0, ((SpacingBuilder)SpacingBuilder.this).myCodeStyleSettings.KEEP_LINE_BREAKS, ((SpacingBuilder)SpacingBuilder.this).myCodeStyleSettings.KEEP_BLANK_LINES_IN_CODE));
            }
            return SpacingBuilder.this;
        }

        public SpacingBuilder blankLines(int count) {
            int blankLines = count + 1;
            for (RuleCondition condition : this.myConditions) {
                SpacingBuilder.this.myRules.add(new SpacingRule(condition, 0, 0, blankLines, ((SpacingBuilder)SpacingBuilder.this).myCodeStyleSettings.KEEP_LINE_BREAKS, ((SpacingBuilder)SpacingBuilder.this).myCodeStyleSettings.KEEP_BLANK_LINES_IN_DECLARATIONS));
            }
            return SpacingBuilder.this;
        }

        public SpacingBuilder lineBreakInCodeIf(boolean option) {
            return option ? this.lineBreakInCode() : SpacingBuilder.this;
        }

        public SpacingBuilder lineBreakInCode() {
            for (RuleCondition condition : this.myConditions) {
                SpacingBuilder.this.myRules.add(new SpacingRule(condition, 0, 0, 1, ((SpacingBuilder)SpacingBuilder.this).myCodeStyleSettings.KEEP_LINE_BREAKS, ((SpacingBuilder)SpacingBuilder.this).myCodeStyleSettings.KEEP_BLANK_LINES_IN_CODE));
            }
            return SpacingBuilder.this;
        }

        public SpacingBuilder lineBreakOrForceSpace(boolean lbOption, boolean spaceOption) {
            if (lbOption) {
                return this.lineBreakInCode();
            }
            int count = spaceOption ? 1 : 0;
            return this.spacing(count, count, 0, false, 0);
        }

        public SpacingBuilder spacing(int minSpaces, int maxSpaces, int minLF, boolean keepLineBreaks, int keepBlankLines) {
            for (RuleCondition condition : this.myConditions) {
                SpacingBuilder.this.myRules.add(new SpacingRule(condition, minSpaces, maxSpaces, minLF, keepLineBreaks, keepBlankLines));
            }
            return SpacingBuilder.this;
        }
    }

    private static class RuleCondition {
        private final TokenSet myParentType;
        private final TokenSet myChild1Type;
        private final TokenSet myChild2Type;

        private RuleCondition(TokenSet parentType, TokenSet child1Type, TokenSet child2Type) {
            this.myParentType = parentType;
            this.myChild1Type = child1Type;
            this.myChild2Type = child2Type;
        }
    }

    private static class SpacingRule {
        private final TokenSet myParentType;
        private final TokenSet myChild1Type;
        private final TokenSet myChild2Type;
        private final int myMinSpaces;
        private final int myMaxSpaces;
        private final int myMinLF;
        private final boolean myKeepLineBreaks;
        private final int myKeepBlankLines;

        private SpacingRule(RuleCondition condition, int minSpaces, int maxSpaces, int minLF, boolean keepLineBreaks, int keepBlankLines) {
            this.myParentType = condition.myParentType;
            this.myChild1Type = condition.myChild1Type;
            this.myChild2Type = condition.myChild2Type;
            this.myMinSpaces = minSpaces;
            this.myMaxSpaces = maxSpaces;
            this.myMinLF = minLF;
            this.myKeepLineBreaks = keepLineBreaks;
            this.myKeepBlankLines = keepBlankLines;
        }

        public boolean matches(IElementType parentType, IElementType child1Type, IElementType child2Type) {
            return !(this.myParentType != null && !this.myParentType.contains(parentType) || this.myChild1Type != null && !this.myChild1Type.contains(child1Type) || this.myChild2Type != null && !this.myChild2Type.contains(child2Type));
        }

        public Spacing createSpacing() {
            return Spacing.createSpacing(this.myMinSpaces, this.myMaxSpaces, this.myMinLF, this.myKeepLineBreaks, this.myKeepBlankLines);
        }
    }
}

