/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.ui.libraries;

import com.intellij.facet.ui.libraries.RemoteRepositoryInfo;
import com.intellij.openapi.util.Comparing;

public class LibraryDownloadInfo {
    private final RemoteRepositoryInfo myRemoteRepository;
    private final String myRelativeDownloadUrl;
    private final String myFileNamePrefix;
    private final String myFileNameSuffix;
    private final String myPresentableUrl;

    public LibraryDownloadInfo(RemoteRepositoryInfo remoteRepository, String relativeDownloadUrl, String fileNamePrefix, String fileNameSuffix) {
        this.myRemoteRepository = remoteRepository;
        this.myRelativeDownloadUrl = relativeDownloadUrl;
        this.myFileNamePrefix = fileNamePrefix;
        this.myFileNameSuffix = fileNameSuffix;
        this.myPresentableUrl = null;
    }

    public LibraryDownloadInfo(String downloadUrl, String presentableUrl, String fileNamePrefix, String fileNameSuffix) {
        this.myRemoteRepository = null;
        this.myRelativeDownloadUrl = downloadUrl;
        this.myFileNamePrefix = fileNamePrefix;
        this.myFileNameSuffix = fileNameSuffix;
        this.myPresentableUrl = presentableUrl != null ? presentableUrl : downloadUrl;
    }

    public LibraryDownloadInfo(String downloadUrl, String presentableUrl, String fileNamePrefix) {
        this(downloadUrl, presentableUrl, fileNamePrefix, ".jar");
    }

    public LibraryDownloadInfo(String downloadUrl, String fileNamePrefix) {
        this(downloadUrl, null, fileNamePrefix);
    }

    public String getDownloadUrl() {
        return this.myRemoteRepository != null ? this.getDownloadUrl(this.myRemoteRepository.getDefaultMirror()) : this.myRelativeDownloadUrl;
    }

    public String getDownloadUrl(String mirror) {
        return mirror + this.myRelativeDownloadUrl;
    }

    public RemoteRepositoryInfo getRemoteRepository() {
        return this.myRemoteRepository;
    }

    public String getFileNamePrefix() {
        return this.myFileNamePrefix;
    }

    public String getFileNameSuffix() {
        return this.myFileNameSuffix;
    }

    public String getFileName() {
        return this.myFileNamePrefix + this.myFileNameSuffix;
    }

    public String getPresentableUrl() {
        return this.myPresentableUrl != null ? this.myPresentableUrl : (this.myRemoteRepository != null ? this.myRemoteRepository.getDefaultMirror() : this.myRelativeDownloadUrl);
    }

    public String getPresentableUrl(String mirror) {
        return this.myPresentableUrl != null ? this.myPresentableUrl : mirror;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LibraryDownloadInfo that = (LibraryDownloadInfo)o;
        if (!this.myFileNamePrefix.equals(that.myFileNamePrefix)) {
            return false;
        }
        if (!this.myFileNameSuffix.equals(that.myFileNameSuffix)) {
            return false;
        }
        if (!Comparing.equal((String)this.myPresentableUrl, (String)that.myPresentableUrl)) {
            return false;
        }
        if (!this.myRelativeDownloadUrl.equals(that.myRelativeDownloadUrl)) {
            return false;
        }
        return Comparing.equal((Object)this.myRemoteRepository, (Object)that.myRemoteRepository);
    }

    public int hashCode() {
        int result = this.myRemoteRepository != null ? this.myRemoteRepository.hashCode() : 0;
        result = 31 * result + (this.myRelativeDownloadUrl != null ? this.myRelativeDownloadUrl.hashCode() : 0);
        result = 31 * result + (this.myFileNamePrefix != null ? this.myFileNamePrefix.hashCode() : 0);
        result = 31 * result + (this.myFileNameSuffix != null ? this.myFileNameSuffix.hashCode() : 0);
        result = 31 * result + (this.myPresentableUrl != null ? this.myPresentableUrl.hashCode() : 0);
        return result;
    }
}

