/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ExecUtil {
    private static final NotNullLazyValue<Boolean> hasGkSudo = new NotNullLazyValue<Boolean>(){

        protected Boolean compute() {
            return new File("/usr/bin/gksudo").canExecute();
        }
    };
    private static final NotNullLazyValue<Boolean> hasKdeSudo = new NotNullLazyValue<Boolean>(){

        protected Boolean compute() {
            return new File("/usr/bin/kdesudo").canExecute();
        }
    };
    private static final NotNullLazyValue<Boolean> hasPkExec = new NotNullLazyValue<Boolean>(){

        protected Boolean compute() {
            return new File("/usr/bin/pkexec").canExecute();
        }
    };
    private static final NotNullLazyValue<Boolean> hasGnomeTerminal = new NotNullLazyValue<Boolean>(){

        protected Boolean compute() {
            return new File("/usr/bin/gnome-terminal").canExecute();
        }
    };
    private static final NotNullLazyValue<Boolean> hasKdeTerminal = new NotNullLazyValue<Boolean>(){

        protected Boolean compute() {
            return new File("/usr/bin/konsole").canExecute();
        }
    };
    private static final NotNullLazyValue<Boolean> hasXTerm = new NotNullLazyValue<Boolean>(){

        protected Boolean compute() {
            return new File("/usr/bin/xterm").canExecute();
        }
    };

    private ExecUtil() {
    }

    public static int execAndGetResult(String ... command) throws ExecutionException, InterruptedException {
        assert (command != null && command.length > 0);
        return ExecUtil.execAndGetResult(Arrays.asList(command));
    }

    public static int execAndGetResult(List<String> command) throws ExecutionException, InterruptedException {
        return new GeneralCommandLine(command).createProcess().waitFor();
    }

    public static String loadTemplate(ClassLoader loader, String templateName, Map<String, String> variables) throws IOException {
        InputStream stream = loader.getResourceAsStream(templateName);
        if (stream == null) {
            throw new IOException("Template '" + templateName + "' not found by " + loader);
        }
        String template = FileUtil.loadTextAndClose((Reader)new InputStreamReader(stream, "UTF-8"));
        if (variables == null || variables.size() == 0) {
            return template;
        }
        StringBuilder buffer = new StringBuilder(template);
        for (Map.Entry<String, String> var : variables.entrySet()) {
            String name = var.getKey();
            int pos = buffer.indexOf(name);
            if (pos < 0) continue;
            buffer.replace(pos, pos + name.length(), var.getValue());
        }
        return buffer.toString();
    }

    public static File createTempExecutableScript(String prefix, String suffix, String content) throws IOException, ExecutionException {
        File tempDir = new File(PathManager.getTempPath());
        File tempFile = FileUtil.createTempFile((File)tempDir, (String)prefix, (String)suffix, (boolean)true, (boolean)true);
        FileUtil.writeToFile((File)tempFile, (byte[])content.getBytes("UTF-8"));
        if (!tempFile.setExecutable(true, true)) {
            throw new ExecutionException("Failed to make temp file executable: " + tempFile);
        }
        return tempFile;
    }

    public static String getOsascriptPath() {
        return "/usr/bin/osascript";
    }

    public static String getOpenCommandPath() {
        return "/usr/bin/open";
    }

    public static String getWindowsShellName() {
        return SystemInfo.isWin2kOrNewer ? "cmd.exe" : "command.com";
    }

    public static ProcessOutput execAndGetOutput(GeneralCommandLine commandLine) throws ExecutionException {
        Process process = commandLine.createProcess();
        CapturingProcessHandler processHandler = new CapturingProcessHandler(process);
        return processHandler.runProcess();
    }

    public static ProcessOutput execAndGetOutput(List<String> command, String workDir) throws ExecutionException {
        Process process = new GeneralCommandLine(command).withWorkDirectory(workDir).createProcess();
        CapturingProcessHandler processHandler = new CapturingProcessHandler(process);
        return processHandler.runProcess();
    }

    public static String execAndReadLine(GeneralCommandLine commandLine) {
        try {
            return ExecUtil.readFirstLine(commandLine.createProcess().getInputStream(), commandLine.getCharset());
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static String execAndReadLine(String ... command) {
        return ExecUtil.execAndReadLine(null, command);
    }

    public static String execAndReadLine(Charset charset, String ... command) {
        try {
            return ExecUtil.readFirstLine(new GeneralCommandLine(command).createProcess().getInputStream(), charset);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFirstLine(InputStream inputStream, Charset charset) {
        String string;
        BufferedReader reader = new BufferedReader(charset == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, charset));
        try {
            string = reader.readLine();
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException ignored) {
                return null;
            }
        }
        reader.close();
        return string;
    }

    public static Process sudo(GeneralCommandLine commandLine, String prompt) throws ExecutionException, IOException {
        File workDir = commandLine.getWorkDirectory();
        ArrayList<String> command = new ArrayList<String>();
        command.add(commandLine.getExePath());
        command.addAll(commandLine.getParametersList().getList());
        Map<String, String> environment = commandLine.getEnvironment();
        if (SystemInfo.isMac) {
            String escapedCommandLine = StringUtil.join(command, (Function)new Function<String, String>(){

                public String fun(String s) {
                    return ExecUtil.escapeAppleScriptArgument(s);
                }
            }, (String)" & \" \" & ");
            String escapedScript = "do shell script " + escapedCommandLine + " with administrator privileges";
            return new GeneralCommandLine(ExecUtil.getOsascriptPath(), "-e", escapedScript).withWorkDirectory(workDir).withEnvironment(environment).createProcess();
        }
        if ("root".equals(System.getenv("USER"))) {
            return new GeneralCommandLine(command).withWorkDirectory(workDir).withEnvironment(environment).createProcess();
        }
        if (((Boolean)hasGkSudo.getValue()).booleanValue()) {
            ArrayList<String> sudoCommand = new ArrayList<String>();
            sudoCommand.addAll(Arrays.asList("gksudo", "--message", prompt, "--"));
            sudoCommand.addAll(command);
            return new GeneralCommandLine(sudoCommand).withWorkDirectory(workDir).withEnvironment(environment).createProcess();
        }
        if (((Boolean)hasKdeSudo.getValue()).booleanValue()) {
            ArrayList<String> sudoCommand = new ArrayList<String>();
            sudoCommand.addAll(Arrays.asList("kdesudo", "--comment", prompt, "--"));
            sudoCommand.addAll(command);
            return new GeneralCommandLine(sudoCommand).withWorkDirectory(workDir).withEnvironment(environment).createProcess();
        }
        if (((Boolean)hasPkExec.getValue()).booleanValue()) {
            ArrayList<String> sudoCommand = new ArrayList<String>();
            sudoCommand.add("pkexec");
            sudoCommand.addAll(command);
            return new GeneralCommandLine(sudoCommand).withWorkDirectory(workDir).withEnvironment(environment).createProcess();
        }
        if (SystemInfo.isUnix && ExecUtil.hasTerminalApp()) {
            String escapedCommandLine = StringUtil.join(command, (Function)new Function<String, String>(){

                public String fun(String s) {
                    return ExecUtil.escapeUnixShellArgument(s);
                }
            }, (String)" ");
            File script = ExecUtil.createTempExecutableScript("sudo", ".sh", "#!/bin/sh\necho " + ExecUtil.escapeUnixShellArgument(prompt) + "\n" + "echo\n" + "sudo -- " + escapedCommandLine + "\n" + "STATUS=$?\n" + "echo\n" + "read -p \"Press Enter to close this window...\" TEMP\n" + "exit $STATUS\n");
            return new GeneralCommandLine(ExecUtil.getTerminalCommand("Install", script.getAbsolutePath())).withWorkDirectory(workDir).withEnvironment(environment).createProcess();
        }
        throw new UnsupportedSystemException();
    }

    public static ProcessOutput sudoAndGetOutput(GeneralCommandLine commandLine, String prompt) throws IOException, ExecutionException {
        Process process = ExecUtil.sudo(commandLine, prompt);
        CapturingProcessHandler processHandler = new CapturingProcessHandler(process);
        return processHandler.runProcess();
    }

    public static ProcessOutput sudoAndGetOutput(List<String> command, String prompt, String workDir) throws IOException, ExecutionException {
        Process process = ExecUtil.sudo(new GeneralCommandLine(command).withWorkDirectory(workDir), prompt);
        CapturingProcessHandler processHandler = new CapturingProcessHandler(process);
        return processHandler.runProcess();
    }

    private static String escapeAppleScriptArgument(String arg) {
        return "quoted form of \"" + arg.replace("\"", "\\\"") + "\"";
    }

    private static String escapeUnixShellArgument(String arg) {
        return "'" + arg.replace("'", "'\"'\"'") + "'";
    }

    public static ProcessOutput sudoAndGetOutput(String scriptPath, String prompt) throws IOException, ExecutionException {
        return ExecUtil.sudoAndGetOutput(scriptPath, prompt, null);
    }

    public static ProcessOutput sudoAndGetOutput(String scriptPath, String prompt, String workDir) throws IOException, ExecutionException {
        if (SystemInfo.isMac) {
            String script = "do shell script \"" + scriptPath + "\" with administrator privileges";
            return ExecUtil.execAndGetOutput(Arrays.asList(ExecUtil.getOsascriptPath(), "-e", script), workDir);
        }
        if ("root".equals(System.getenv("USER"))) {
            return ExecUtil.execAndGetOutput(Collections.singletonList(scriptPath), workDir);
        }
        if (((Boolean)hasKdeSudo.getValue()).booleanValue()) {
            return ExecUtil.execAndGetOutput(Arrays.asList("kdesudo", "--comment", prompt, scriptPath), workDir);
        }
        if (((Boolean)hasGkSudo.getValue()).booleanValue()) {
            return ExecUtil.execAndGetOutput(Arrays.asList("gksudo", "--message", prompt, scriptPath), workDir);
        }
        if (((Boolean)hasPkExec.getValue()).booleanValue()) {
            return ExecUtil.execAndGetOutput(Arrays.asList("pkexec", scriptPath), workDir);
        }
        if (SystemInfo.isUnix && ExecUtil.hasTerminalApp()) {
            File sudo = ExecUtil.createTempExecutableScript("sudo", ".sh", "#!/bin/sh\necho \"" + prompt + "\"\n" + "echo\n" + "sudo " + scriptPath + "\n" + "STATUS=$?\n" + "echo\n" + "read -p \"Press Enter to close this window...\" TEMP\n" + "exit $STATUS\n");
            return ExecUtil.execAndGetOutput(ExecUtil.getTerminalCommand("Install", sudo.getAbsolutePath()), workDir);
        }
        throw new UnsupportedSystemException();
    }

    public static int sudoAndGetResult(String scriptPath, String prompt) throws IOException, ExecutionException {
        return ExecUtil.sudoAndGetOutput(scriptPath, prompt, null).getExitCode();
    }

    public static boolean hasTerminalApp() {
        return SystemInfo.isWindows || SystemInfo.isMac || (Boolean)hasKdeTerminal.getValue() != false || (Boolean)hasGnomeTerminal.getValue() != false || (Boolean)hasXTerm.getValue() != false;
    }

    public static List<String> getTerminalCommand(String title, String command) {
        if (SystemInfo.isWindows) {
            title = title != null ? title.replace("\"", "'") : "";
            return Arrays.asList(ExecUtil.getWindowsShellName(), "/c", "start", GeneralCommandLine.inescapableQuote(title), command);
        }
        if (SystemInfo.isMac) {
            return Arrays.asList(ExecUtil.getOpenCommandPath(), "-a", "Terminal", command);
        }
        if (((Boolean)hasKdeTerminal.getValue()).booleanValue()) {
            return Arrays.asList("/usr/bin/konsole", "-e", command);
        }
        if (((Boolean)hasGnomeTerminal.getValue()).booleanValue()) {
            return title != null ? Arrays.asList("/usr/bin/gnome-terminal", "-t", title, "-x", command) : Arrays.asList("/usr/bin/gnome-terminal", "-x", command);
        }
        if (((Boolean)hasXTerm.getValue()).booleanValue()) {
            return title != null ? Arrays.asList("/usr/bin/xterm", "-T", title, "-e", command) : Arrays.asList("/usr/bin/xterm", "-e", command);
        }
        throw new UnsupportedSystemException();
    }

    public static class UnsupportedSystemException
    extends UnsupportedOperationException {
        public UnsupportedSystemException() {
            super("Unsupported OS/desktop: " + SystemInfo.OS_NAME + '/' + SystemInfo.SUN_DESKTOP);
        }
    }
}

