/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.keyFMap.KeyFMap;

public final class ExecutionEnvironmentBuilder {
    private RunProfile myRunProfile;
    private ExecutionTarget myTarget = DefaultExecutionTarget.INSTANCE;
    private final Project myProject;
    private RunnerSettings myRunnerSettings;
    private ConfigurationPerRunnerSettings myConfigurationSettings;
    private RunContentDescriptor myContentToReuse;
    private RunnerAndConfigurationSettings myRunnerAndConfigurationSettings;
    private String myRunnerId;
    private ProgramRunner<?> myRunner;
    private boolean myAssignNewId;
    private Executor myExecutor;
    private DataContext myDataContext;
    private KeyFMap myCopyableUserData;

    public ExecutionEnvironmentBuilder(Project project, Executor executor) {
        this.myProject = project;
        this.myExecutor = executor;
    }

    public static ExecutionEnvironmentBuilder create(Project project, Executor executor, RunProfile runProfile) throws ExecutionException {
        ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.createOrNull(project, executor, runProfile);
        if (builder == null) {
            throw new ExecutionException("Cannot find runner for " + runProfile.getName());
        }
        return builder;
    }

    public static ExecutionEnvironmentBuilder createOrNull(Project project, Executor executor, RunProfile runProfile) {
        ProgramRunner runner = RunnerRegistry.getInstance().getRunner(executor.getId(), runProfile);
        if (runner == null) {
            return null;
        }
        return new ExecutionEnvironmentBuilder(project, executor).runner(runner).runProfile(runProfile);
    }

    public static ExecutionEnvironmentBuilder createOrNull(Executor executor, RunnerAndConfigurationSettings settings) {
        ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.createOrNull(settings.getConfiguration().getProject(), executor, settings.getConfiguration());
        return builder == null ? null : builder.runnerAndSettings(builder.myRunner, settings);
    }

    public static ExecutionEnvironmentBuilder create(Executor executor, RunnerAndConfigurationSettings settings) throws ExecutionException {
        ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.create(settings.getConfiguration().getProject(), executor, settings.getConfiguration());
        return builder.runnerAndSettings(builder.myRunner, settings);
    }

    public static ExecutionEnvironmentBuilder create(Executor executor, RunConfiguration configuration) {
        return new ExecutionEnvironmentBuilder(configuration.getProject(), executor).runProfile(configuration);
    }

    Executor getExecutor() {
        return this.myExecutor;
    }

    public ExecutionEnvironmentBuilder(ExecutionEnvironment copySource) {
        this.myTarget = copySource.getExecutionTarget();
        this.myProject = copySource.getProject();
        this.myRunnerAndConfigurationSettings = copySource.getRunnerAndConfigurationSettings();
        this.myRunProfile = copySource.getRunProfile();
        this.myRunnerSettings = copySource.getRunnerSettings();
        this.myConfigurationSettings = copySource.getConfigurationSettings();
        this.myRunner = copySource.getRunner();
        this.myContentToReuse = copySource.getContentToReuse();
        this.myExecutor = copySource.getExecutor();
        this.myCopyableUserData = (KeyFMap)copySource.getUserData(UserDataHolderBase.COPYABLE_USER_MAP_KEY);
    }

    @Deprecated
    public ExecutionEnvironmentBuilder setTarget(ExecutionTarget target) {
        return this.target(target);
    }

    public ExecutionEnvironmentBuilder target(ExecutionTarget target) {
        if (target != null) {
            this.myTarget = target;
        }
        return this;
    }

    public ExecutionEnvironmentBuilder activeTarget() {
        this.myTarget = ExecutionTargetManager.getActiveTarget(this.myProject);
        return this;
    }

    @Deprecated
    public ExecutionEnvironmentBuilder setRunnerAndSettings(ProgramRunner programRunner, RunnerAndConfigurationSettings settings) {
        return this.runnerAndSettings(programRunner, settings);
    }

    public ExecutionEnvironmentBuilder runnerAndSettings(ProgramRunner runner, RunnerAndConfigurationSettings settings) {
        this.myRunnerAndConfigurationSettings = settings;
        this.myRunProfile = settings.getConfiguration();
        this.myRunnerSettings = settings.getRunnerSettings(runner);
        this.myConfigurationSettings = settings.getConfigurationSettings(runner);
        this.myRunner = runner;
        return this;
    }

    @Deprecated
    public ExecutionEnvironmentBuilder setRunnerSettings(RunnerSettings runnerSettings) {
        this.myRunnerSettings = runnerSettings;
        return this;
    }

    public ExecutionEnvironmentBuilder runnerSettings(RunnerSettings runnerSettings) {
        this.myRunnerSettings = runnerSettings;
        return this;
    }

    @Deprecated
    public ExecutionEnvironmentBuilder setConfigurationSettings(ConfigurationPerRunnerSettings configurationSettings) {
        this.myConfigurationSettings = configurationSettings;
        return this;
    }

    @Deprecated
    public ExecutionEnvironmentBuilder setContentToReuse(RunContentDescriptor contentToReuse) {
        this.contentToReuse(contentToReuse);
        return this;
    }

    public ExecutionEnvironmentBuilder contentToReuse(RunContentDescriptor contentToReuse) {
        this.myContentToReuse = contentToReuse;
        return this;
    }

    @Deprecated
    public ExecutionEnvironmentBuilder setRunProfile(RunProfile runProfile) {
        return this.runProfile(runProfile);
    }

    public ExecutionEnvironmentBuilder runProfile(RunProfile runProfile) {
        this.myRunProfile = runProfile;
        return this;
    }

    @Deprecated
    public ExecutionEnvironmentBuilder setRunnerId(String runnerId) {
        this.myRunnerId = runnerId;
        return this;
    }

    public ExecutionEnvironmentBuilder runner(ProgramRunner<?> runner) {
        this.myRunner = runner;
        return this;
    }

    public ExecutionEnvironmentBuilder assignNewId() {
        this.myAssignNewId = true;
        return this;
    }

    @Deprecated
    public ExecutionEnvironmentBuilder setDataContext(DataContext dataContext) {
        return this.dataContext(dataContext);
    }

    public ExecutionEnvironmentBuilder dataContext(DataContext dataContext) {
        this.myDataContext = dataContext;
        return this;
    }

    @Deprecated
    public ExecutionEnvironmentBuilder setExecutor(Executor executor) {
        return this.executor(executor);
    }

    public ExecutionEnvironmentBuilder executor(Executor executor) {
        this.myExecutor = executor;
        return this;
    }

    public ExecutionEnvironment build() {
        if (this.myRunner == null) {
            this.myRunner = this.myRunnerId == null ? RunnerRegistry.getInstance().getRunner(this.myExecutor.getId(), this.myRunProfile) : RunnerRegistry.getInstance().findRunnerById(this.myRunnerId);
        }
        if (this.myRunner == null) {
            throw new IllegalStateException("Runner must be specified");
        }
        ExecutionEnvironment environment = new ExecutionEnvironment(this.myRunProfile, this.myExecutor, this.myTarget, this.myProject, this.myRunnerSettings, this.myConfigurationSettings, this.myContentToReuse, this.myRunnerAndConfigurationSettings, this.myRunner);
        if (this.myAssignNewId) {
            environment.assignNewExecutionId();
        }
        if (this.myDataContext != null) {
            environment.setDataContext(this.myDataContext);
        }
        if (this.myCopyableUserData != null) {
            environment.putUserData(UserDataHolderBase.COPYABLE_USER_MAP_KEY, this.myCopyableUserData);
        }
        return environment;
    }

    public void buildAndExecute() throws ExecutionException {
        ExecutionEnvironment environment = this.build();
        this.myRunner.execute(environment);
    }
}

