/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.options.SettingsEditor;

abstract class BaseProgramRunner<Settings extends RunnerSettings>
implements ProgramRunner<Settings> {
    BaseProgramRunner() {
    }

    @Override
    public Settings createConfigurationData(ConfigurationInfoProvider settingsProvider) {
        return null;
    }

    @Override
    public void checkConfiguration(RunnerSettings settings, ConfigurationPerRunnerSettings configurationPerRunnerSettings) throws RuntimeConfigurationException {
    }

    @Override
    public void onProcessStarted(RunnerSettings settings, ExecutionResult executionResult) {
    }

    @Override
    public SettingsEditor<Settings> getSettingsEditor(Executor executor, RunConfiguration configuration) {
        return null;
    }

    @Override
    public void execute(ExecutionEnvironment environment) throws ExecutionException {
        this.execute(environment, null);
    }

    @Override
    public void execute(ExecutionEnvironment environment, ProgramRunner.Callback callback) throws ExecutionException {
        RunProfileState state = environment.getState();
        if (state == null) {
            return;
        }
        RunManager.getInstance(environment.getProject()).refreshUsagesList(environment.getRunProfile());
        this.execute(environment, callback, state);
    }

    protected abstract void execute(ExecutionEnvironment var1, ProgramRunner.Callback var2, RunProfileState var3) throws ExecutionException;

    static RunContentDescriptor postProcess(ExecutionEnvironment environment, RunContentDescriptor descriptor, ProgramRunner.Callback callback) {
        if (descriptor != null) {
            descriptor.setExecutionId(environment.getExecutionId());
        }
        if (callback != null) {
            callback.processStarted(descriptor);
        }
        return descriptor;
    }
}

