/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.SearchScopeProvidingRunProfile;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;

public class SearchScopeProvider {
    public static GlobalSearchScope createSearchScope(Project project, RunProfile runProfile) {
        Module[] modules = null;
        if (runProfile instanceof SearchScopeProvidingRunProfile) {
            modules = ((SearchScopeProvidingRunProfile)runProfile).getModules();
        }
        if (modules == null || modules.length == 0) {
            return GlobalSearchScope.allScope(project);
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleRuntimeScope(modules[0], true);
        for (int idx = 1; idx < modules.length; ++idx) {
            Module module = modules[idx];
            scope = scope.uniteWith(GlobalSearchScope.moduleRuntimeScope(module, true));
        }
        return scope;
    }
}

