/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineBuilder;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.JavaCommandLineStateUtil;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;

public abstract class JavaCommandLineState
extends CommandLineState
implements JavaCommandLine {
    private JavaParameters myParams;

    protected JavaCommandLineState(ExecutionEnvironment environment) {
        super(environment);
    }

    @Override
    public JavaParameters getJavaParameters() throws ExecutionException {
        if (this.myParams == null) {
            this.myParams = this.createJavaParameters();
        }
        return this.myParams;
    }

    protected OSProcessHandler startProcess() throws ExecutionException {
        return JavaCommandLineStateUtil.startProcess(this.createCommandLine(), this.ansiColoringEnabled());
    }

    protected boolean ansiColoringEnabled() {
        return false;
    }

    protected abstract JavaParameters createJavaParameters() throws ExecutionException;

    protected GeneralCommandLine createCommandLine() throws ExecutionException {
        return CommandLineBuilder.createFromJavaParameters(this.getJavaParameters(), CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext()), true);
    }

    public boolean shouldAddJavaProgramRunnerActions() {
        return true;
    }
}

