/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class GeneralCommandLine
implements UserDataHolder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.configurations.GeneralCommandLine");
    private String myExePath = null;
    private File myWorkDirectory = null;
    private final Map<String, String> myEnvParams = new MyTHashMap();
    private boolean myPassParentEnvironment = true;
    private final ParametersList myProgramParams = new ParametersList();
    private Charset myCharset = CharsetToolkit.getDefaultSystemCharset();
    private boolean myRedirectErrorStream = false;
    private Map<Object, Object> myUserData = null;

    public GeneralCommandLine() {
    }

    public GeneralCommandLine(String ... command) {
        this(Arrays.asList(command));
    }

    public GeneralCommandLine(List<String> command) {
        int size = command.size();
        if (size > 0) {
            this.setExePath(command.get(0));
            if (size > 1) {
                this.addParameters(command.subList(1, size));
            }
        }
    }

    public String getExePath() {
        return this.myExePath;
    }

    public void setExePath(String exePath) {
        this.myExePath = exePath.trim();
    }

    public File getWorkDirectory() {
        return this.myWorkDirectory;
    }

    public GeneralCommandLine withWorkDirectory(String path) {
        return this.withWorkDirectory(path != null ? new File(path) : null);
    }

    public GeneralCommandLine withWorkDirectory(File workDirectory) {
        this.myWorkDirectory = workDirectory;
        return this;
    }

    public void setWorkDirectory(String path) {
        this.withWorkDirectory(path);
    }

    public void setWorkDirectory(File workDirectory) {
        this.myWorkDirectory = workDirectory;
    }

    public Map<String, String> getEnvironment() {
        return this.myEnvParams;
    }

    public GeneralCommandLine withEnvironment(Map<String, String> environment) {
        if (environment != null) {
            this.getEnvironment().putAll(environment);
        }
        return this;
    }

    public Map<String, String> getEnvParams() {
        return this.getEnvironment();
    }

    public void setEnvParams(Map<String, String> envParams) {
        this.myEnvParams.clear();
        if (envParams != null) {
            this.myEnvParams.putAll(envParams);
        }
    }

    public void setPassParentEnvironment(boolean passParentEnvironment) {
        this.myPassParentEnvironment = passParentEnvironment;
    }

    public void setPassParentEnvs(boolean passParentEnvironment) {
        this.setPassParentEnvironment(passParentEnvironment);
    }

    public boolean isPassParentEnvironment() {
        return this.myPassParentEnvironment;
    }

    public Map<String, String> getParentEnvironment() {
        return PlatformUtils.isAppCode() ? System.getenv() : EnvironmentUtil.getEnvironmentMap();
    }

    public void addParameters(String ... parameters) {
        for (String parameter : parameters) {
            this.addParameter(parameter);
        }
    }

    public void addParameters(List<String> parameters) {
        for (String parameter : parameters) {
            this.addParameter(parameter);
        }
    }

    public void addParameter(String parameter) {
        this.myProgramParams.add(parameter);
    }

    public ParametersList getParametersList() {
        return this.myProgramParams;
    }

    public Charset getCharset() {
        return this.myCharset;
    }

    public GeneralCommandLine withCharset(Charset charset) {
        this.myCharset = charset;
        return this;
    }

    public void setCharset(Charset charset) {
        this.myCharset = charset;
    }

    public boolean isRedirectErrorStream() {
        return this.myRedirectErrorStream;
    }

    public void setRedirectErrorStream(boolean redirectErrorStream) {
        this.myRedirectErrorStream = redirectErrorStream;
    }

    public String getCommandLineString() {
        return this.getCommandLineString(null);
    }

    public String getCommandLineString(String exeName) {
        return ParametersList.join(this.getCommandLineList(exeName));
    }

    public List<String> getCommandLineList(String exeName) {
        ArrayList<String> commands = new ArrayList<String>();
        if (exeName != null) {
            commands.add(exeName);
        } else if (this.myExePath != null) {
            commands.add(this.myExePath);
        } else {
            commands.add("<null>");
        }
        commands.addAll(this.myProgramParams.getList());
        return commands;
    }

    public String getPreparedCommandLine(Platform platform) {
        String exePath = this.myExePath != null ? this.myExePath : "";
        return StringUtil.join((Collection)CommandLineUtil.toCommandLine((String)exePath, this.myProgramParams.getList(), (Platform)platform), (String)"\n");
    }

    public Process createProcess() throws ExecutionException {
        List commands;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing [" + this.getCommandLineString() + "]");
        }
        try {
            this.checkWorkingDirectory();
            if (StringUtil.isEmptyOrSpaces((String)this.myExePath)) {
                throw new ExecutionException(IdeBundle.message("run.configuration.error.executable.not.specified", new Object[0]));
            }
            commands = CommandLineUtil.toCommandLine((String)this.myExePath, this.myProgramParams.getList());
        }
        catch (ExecutionException e) {
            LOG.info((Throwable)e);
            throw e;
        }
        try {
            return this.startProcess(commands);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            throw new ProcessNotCreatedException(e.getMessage(), e, this);
        }
    }

    protected Process startProcess(List<String> commands) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(commands);
        this.setupEnvironment(builder.environment());
        builder.directory(this.myWorkDirectory);
        builder.redirectErrorStream(this.myRedirectErrorStream);
        return builder.start();
    }

    private void checkWorkingDirectory() throws ExecutionException {
        if (this.myWorkDirectory == null) {
            return;
        }
        if (!this.myWorkDirectory.exists()) {
            throw new ExecutionException(IdeBundle.message("run.configuration.error.working.directory.does.not.exist", this.myWorkDirectory.getAbsolutePath()));
        }
        if (!this.myWorkDirectory.isDirectory()) {
            throw new ExecutionException(IdeBundle.message("run.configuration.error.working.directory.not.directory", new Object[0]));
        }
    }

    protected void setupEnvironment(Map<String, String> environment) {
        environment.clear();
        if (this.myPassParentEnvironment) {
            environment.putAll(this.getParentEnvironment());
        }
        if (!this.myEnvParams.isEmpty()) {
            if (SystemInfo.isWindows) {
                THashMap envVars = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
                envVars.putAll(environment);
                envVars.putAll(this.myEnvParams);
                environment.clear();
                environment.putAll((Map<String, String>)envVars);
            } else {
                environment.putAll(this.myEnvParams);
            }
        }
    }

    public static String inescapableQuote(String parameter) {
        return CommandLineUtil.specialQuote((String)parameter);
    }

    public String toString() {
        return this.myExePath + " " + this.myProgramParams;
    }

    public <T> T getUserData(Key<T> key) {
        if (this.myUserData != null) {
            Object t = this.myUserData.get(key);
            return (T)t;
        }
        return null;
    }

    public <T> void putUserData(Key<T> key, T value) {
        if (this.myUserData == null) {
            this.myUserData = ContainerUtil.newHashMap();
        }
        this.myUserData.put(key, value);
    }

    private static class MyTHashMap
    extends THashMap<String, String> {
        private MyTHashMap() {
        }

        public String put(String key, String value) {
            if (key == null || value == null) {
                LOG.error((Throwable)new Exception("Nulls are not allowed"));
                return null;
            }
            if (key.isEmpty()) {
                LOG.warn("Skipping environment variable with empty name, value: " + value);
                return null;
            }
            return (String)super.put((Object)key, (Object)value);
        }

        public void putAll(Map<? extends String, ? extends String> map) {
            if (map != null) {
                super.putAll(map);
            }
        }
    }
}

