/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.PreferredProducerFind;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.RuntimeConfigurationProducer;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.awt.Component;
import java.util.List;

public class ConfigurationContext {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.actions.ConfigurationContext");
    private final Location<PsiElement> myLocation;
    private RunnerAndConfigurationSettings myConfiguration;
    private Ref<RunnerAndConfigurationSettings> myExistingConfiguration;
    private final Module myModule;
    private final RunConfiguration myRuntimeConfiguration;
    private final Component myContextComponent;
    public static Key<ConfigurationContext> SHARED_CONTEXT = Key.create((String)"SHARED_CONTEXT");
    private List<RuntimeConfigurationProducer> myPreferredProducers;
    private List<ConfigurationFromContext> myConfigurationsFromContext;

    public static ConfigurationContext getFromContext(DataContext dataContext) {
        ConfigurationContext context = new ConfigurationContext(dataContext);
        DataManager dataManager = DataManager.getInstance();
        ConfigurationContext sharedContext = dataManager.loadFromDataContext(dataContext, SHARED_CONTEXT);
        if (sharedContext == null || sharedContext.getLocation() == null || context.getLocation() == null || !Comparing.equal(sharedContext.getLocation().getPsiElement(), context.getLocation().getPsiElement())) {
            sharedContext = context;
            dataManager.saveInDataContext(dataContext, SHARED_CONTEXT, sharedContext);
        }
        return sharedContext;
    }

    private ConfigurationContext(DataContext dataContext) {
        this.myRuntimeConfiguration = RunConfiguration.DATA_KEY.getData(dataContext);
        this.myContextComponent = PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
        this.myModule = LangDataKeys.MODULE.getData(dataContext);
        Location<?> location = Location.DATA_KEY.getData(dataContext);
        if (location != null) {
            this.myLocation = location;
            return;
        }
        Project project = CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            this.myLocation = null;
            return;
        }
        PsiElement element = ConfigurationContext.getSelectedPsiElement(dataContext, project);
        if (element == null) {
            this.myLocation = null;
            return;
        }
        this.myLocation = new PsiLocation<PsiElement>(project, this.myModule, element);
    }

    public RunnerAndConfigurationSettings getConfiguration() {
        if (this.myConfiguration == null) {
            this.createConfiguration();
        }
        return this.myConfiguration;
    }

    private void createConfiguration() {
        LOG.assertTrue(this.myConfiguration == null);
        Location location = this.getLocation();
        this.myConfiguration = location != null && !DumbService.isDumb(location.getProject()) ? PreferredProducerFind.createConfiguration(location, this) : null;
    }

    public void setConfiguration(RunnerAndConfigurationSettings configuration) {
        this.myConfiguration = configuration;
    }

    @Deprecated
    public RunnerAndConfigurationSettings updateConfiguration(RuntimeConfigurationProducer producer) {
        this.myConfiguration = producer.getConfiguration();
        return this.myConfiguration;
    }

    public Location getLocation() {
        return this.myLocation;
    }

    public PsiElement getPsiLocation() {
        return this.myLocation != null ? this.myLocation.getPsiElement() : null;
    }

    public RunnerAndConfigurationSettings findExisting() {
        RunnerAndConfigurationSettings configuration;
        if (this.myExistingConfiguration != null) {
            return (RunnerAndConfigurationSettings)this.myExistingConfiguration.get();
        }
        this.myExistingConfiguration = new Ref();
        if (this.myLocation == null) {
            return null;
        }
        PsiElement psiElement = this.myLocation.getPsiElement();
        if (!psiElement.isValid()) {
            return null;
        }
        List<RuntimeConfigurationProducer> producers = this.findPreferredProducers();
        if (this.myRuntimeConfiguration != null) {
            if (producers != null) {
                for (RuntimeConfigurationProducer runtimeConfigurationProducer : producers) {
                    configuration = runtimeConfigurationProducer.findExistingConfiguration(this.myLocation, this);
                    if (configuration == null || configuration.getConfiguration() != this.myRuntimeConfiguration) continue;
                    this.myExistingConfiguration.set((Object)configuration);
                }
            }
            for (RunConfigurationProducer runConfigurationProducer : RunConfigurationProducer.getProducers(this.getProject())) {
                configuration = runConfigurationProducer.findExistingConfiguration(this);
                if (configuration == null || configuration.getConfiguration() != this.myRuntimeConfiguration) continue;
                this.myExistingConfiguration.set((Object)configuration);
            }
        }
        if (producers != null) {
            for (RuntimeConfigurationProducer runtimeConfigurationProducer : producers) {
                configuration = runtimeConfigurationProducer.findExistingConfiguration(this.myLocation, this);
                if (configuration == null) continue;
                this.myExistingConfiguration.set((Object)configuration);
            }
        }
        for (RunConfigurationProducer runConfigurationProducer : RunConfigurationProducer.getProducers(this.getProject())) {
            configuration = runConfigurationProducer.findExistingConfiguration(this);
            if (configuration == null) continue;
            this.myExistingConfiguration.set((Object)configuration);
        }
        return (RunnerAndConfigurationSettings)this.myExistingConfiguration.get();
    }

    private static PsiElement getSelectedPsiElement(DataContext dataContext, Project project) {
        VirtualFile[] files;
        int offset;
        PsiFile psiFile;
        PsiElement element = null;
        Editor editor = CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null && (psiFile = PsiDocumentManager.getInstance(project).getPsiFile(editor.getDocument())) != null && (element = psiFile.findElementAt(offset = editor.getCaretModel().getOffset())) == null && offset > 0 && offset == psiFile.getTextLength()) {
            element = psiFile.findElementAt(offset - 1);
        }
        if (element == null) {
            PsiElement[] elements = LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
            PsiElement psiElement = element = elements != null && elements.length > 0 ? elements[0] : null;
        }
        if (element == null && (files = CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext)) != null && files.length > 0) {
            element = PsiManager.getInstance(project).findFile(files[0]);
        }
        return element;
    }

    public RunManager getRunManager() {
        return RunManager.getInstance(this.getProject());
    }

    public Project getProject() {
        return this.myLocation.getProject();
    }

    public Module getModule() {
        return this.myModule;
    }

    public DataContext getDataContext() {
        return DataManager.getInstance().getDataContext(this.myContextComponent);
    }

    public RunConfiguration getOriginalConfiguration(ConfigurationType type) {
        if (type == null) {
            return this.myRuntimeConfiguration;
        }
        if (this.myRuntimeConfiguration != null && ConfigurationTypeUtil.equals(this.myRuntimeConfiguration.getType(), type)) {
            return this.myRuntimeConfiguration;
        }
        return null;
    }

    @Deprecated
    public List<RuntimeConfigurationProducer> findPreferredProducers() {
        if (this.myPreferredProducers == null) {
            this.myPreferredProducers = PreferredProducerFind.findPreferredProducers(this.myLocation, this, true);
        }
        return this.myPreferredProducers;
    }

    public List<ConfigurationFromContext> getConfigurationsFromContext() {
        if (this.myConfigurationsFromContext == null) {
            this.myConfigurationsFromContext = PreferredProducerFind.getConfigurationsFromContext(this.myLocation, this, true);
        }
        return this.myConfigurationsFromContext;
    }
}

