/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.chains;

import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;

public class SimpleDiffRequestChain
extends UserDataHolderBase
implements DiffRequestChain {
    private final List<DiffRequestProducerWrapper> myRequests;
    private int myIndex = 0;

    public SimpleDiffRequestChain(DiffRequest request) {
        this(Collections.singletonList(request));
    }

    public SimpleDiffRequestChain(List<? extends DiffRequest> requests) {
        this.myRequests = ContainerUtil.map(requests, (Function)new Function<DiffRequest, DiffRequestProducerWrapper>(){

            public DiffRequestProducerWrapper fun(DiffRequest request) {
                return new DiffRequestProducerWrapper(request);
            }
        });
    }

    public List<DiffRequestProducerWrapper> getRequests() {
        return this.myRequests;
    }

    @Override
    public int getIndex() {
        return this.myIndex;
    }

    @Override
    public void setIndex(int index) {
        assert (index >= 0 && index < this.myRequests.size());
        this.myIndex = index;
    }

    public static class DiffRequestProducerWrapper
    implements DiffRequestProducer {
        private final DiffRequest myRequest;

        public DiffRequestProducerWrapper(DiffRequest request) {
            this.myRequest = request;
        }

        public DiffRequest getRequest() {
            return this.myRequest;
        }

        @Override
        public String getName() {
            return StringUtil.notNullize((String)this.myRequest.getTitle(), (String)"Change");
        }

        @Override
        public DiffRequest process(UserDataHolder context, ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
            return this.myRequest;
        }
    }
}

