/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;

public abstract class JobScheduler {
    private static final ScheduledThreadPoolExecutor ourScheduledExecutorService;
    private static final int TASK_LIMIT = 50;
    private static final Logger LOG;
    private static final ThreadLocal<Long> START;
    private static final boolean DO_TIMING = true;

    private static Object info(Runnable r) {
        if (!(r instanceof FutureTask)) {
            return r;
        }
        Object sync = ReflectionUtil.getField(FutureTask.class, (Object)r, null, (String)"sync");
        Object o = sync == null ? r : sync;
        Object callable = ReflectionUtil.getField(o.getClass(), (Object)o, Callable.class, (String)"callable");
        if (callable == null) {
            return null;
        }
        Object task = ReflectionUtil.getField(callable.getClass(), (Object)callable, null, (String)"task");
        return task == null ? callable : task;
    }

    private static void enableRemoveOnCancelPolicy(ScheduledThreadPoolExecutor executor) {
        try {
            Method setRemoveOnCancelPolicy = ReflectionUtil.getDeclaredMethod(ScheduledThreadPoolExecutor.class, (String)"setRemoveOnCancelPolicy", (Class[])new Class[]{Boolean.TYPE});
            setRemoveOnCancelPolicy.invoke((Object)executor, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static JobScheduler getInstance() {
        return ServiceManager.getService(JobScheduler.class);
    }

    public static ScheduledExecutorService getScheduler() {
        return ourScheduledExecutorService;
    }

    static {
        LOG = Logger.getInstance((String)"#com.intellij.concurrency.JobScheduler");
        START = new ThreadLocal();
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, ConcurrencyUtil.newNamedThreadFactory((String)"Periodic tasks thread", (boolean)true, (int)5)){

            @Override
            protected void beforeExecute(Thread t, Runnable r) {
                START.set(System.currentTimeMillis());
            }

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                Object unwrapped;
                long elapsed = System.currentTimeMillis() - (Long)START.get();
                if (elapsed > 50L && (unwrapped = JobScheduler.info(r)) != null) {
                    String msg = "50 ms execution limit failed for: " + unwrapped + "; elapsed time was " + elapsed + "ms";
                    LOG.info(msg);
                }
            }
        };
        executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        JobScheduler.enableRemoveOnCancelPolicy(executor);
        ourScheduledExecutorService = executor;
    }
}

