/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.Chunk;
import java.nio.charset.Charset;
import java.util.Collection;

public abstract class CompilerEncodingService {
    public static CompilerEncodingService getInstance(Project project) {
        return ServiceManager.getService(project, CompilerEncodingService.class);
    }

    public static Charset getPreferredModuleEncoding(Chunk<Module> chunk) {
        CompilerEncodingService service = null;
        for (Module module : chunk.getNodes()) {
            Charset charset;
            if (service == null) {
                service = CompilerEncodingService.getInstance(module.getProject());
            }
            if ((charset = service.getPreferredModuleEncoding(module)) == null) continue;
            return charset;
        }
        return null;
    }

    public abstract Charset getPreferredModuleEncoding(Module var1);

    public abstract Collection<Charset> getAllModuleEncodings(Module var1);
}

