/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;

public abstract class LocalQuickFixOnPsiElement
implements LocalQuickFix {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.LocalQuickFixAndIntentionAction");
    protected final SmartPsiElementPointer<PsiElement> myStartElement;
    protected final SmartPsiElementPointer<PsiElement> myEndElement;

    protected LocalQuickFixOnPsiElement(PsiElement element) {
        this(element, element);
    }

    public LocalQuickFixOnPsiElement(PsiElement startElement, PsiElement endElement) {
        PsiFile endContainingFile;
        if (startElement == null || endElement == null) {
            this.myEndElement = null;
            this.myStartElement = null;
            return;
        }
        LOG.assertTrue(startElement.isValid());
        PsiFile startContainingFile = startElement.getContainingFile();
        PsiFile psiFile = endContainingFile = startElement == endElement ? startContainingFile : endElement.getContainingFile();
        if (startElement != endElement) {
            LOG.assertTrue(endElement.isValid());
            LOG.assertTrue(startContainingFile == endContainingFile, (Object)"Both elements must be from the same file");
        }
        Project project = startContainingFile == null ? startElement.getProject() : startContainingFile.getProject();
        this.myStartElement = SmartPointerManager.getInstance(project).createSmartPsiElementPointer(startElement, startContainingFile);
        this.myEndElement = endElement == startElement ? null : SmartPointerManager.getInstance(project).createSmartPsiElementPointer(endElement, endContainingFile);
    }

    @Override
    public final String getName() {
        return this.getText();
    }

    public boolean isAvailable(Project project, PsiFile file, PsiElement startElement, PsiElement endElement) {
        return true;
    }

    protected boolean isAvailable() {
        if (this.myStartElement == null) {
            return false;
        }
        PsiElement startElement = this.myStartElement.getElement();
        PsiElement endElement = this.myEndElement == null ? startElement : this.myEndElement.getElement();
        PsiFile file = this.myStartElement.getContainingFile();
        Project project = this.myStartElement.getProject();
        return startElement != null && endElement != null && startElement.isValid() && (endElement == startElement || endElement.isValid()) && file != null && this.isAvailable(project, file, startElement, endElement);
    }

    public PsiElement getStartElement() {
        return this.myStartElement == null ? null : this.myStartElement.getElement();
    }

    public PsiElement getEndElement() {
        return this.myEndElement == null ? null : this.myEndElement.getElement();
    }

    public abstract String getText();

    @Override
    public final void applyFix(Project project, ProblemDescriptor descriptor) {
        this.applyFix();
    }

    public void applyFix() {
        PsiElement endElement;
        if (this.myStartElement == null) {
            return;
        }
        PsiElement startElement = this.myStartElement.getElement();
        PsiElement psiElement = endElement = this.myEndElement == null ? startElement : this.myEndElement.getElement();
        if (startElement == null || endElement == null) {
            return;
        }
        PsiFile file = startElement.getContainingFile();
        if (file == null) {
            return;
        }
        this.invoke(file.getProject(), file, startElement, endElement);
    }

    public abstract void invoke(Project var1, PsiFile var2, PsiElement var3, PsiElement var4);
}

