/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.IncorrectOperationException;

public abstract class PsiElementBaseIntentionAction
extends BaseIntentionAction {
    @Override
    public final void invoke(Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (!file.getManager().isInProject(file)) {
            return;
        }
        PsiElement element = PsiElementBaseIntentionAction.getElement(editor, file);
        if (element != null) {
            this.invoke(project, editor, element);
        }
    }

    public abstract void invoke(Project var1, Editor var2, PsiElement var3) throws IncorrectOperationException;

    @Override
    public final boolean isAvailable(Project project, Editor editor, PsiFile file) {
        if (file == null) {
            return false;
        }
        PsiManager manager = file.getManager();
        if (manager == null) {
            return false;
        }
        if (!manager.isInProject(file)) {
            return false;
        }
        PsiElement element = PsiElementBaseIntentionAction.getElement(editor, file);
        return element != null && this.isAvailable(project, editor, element);
    }

    public abstract boolean isAvailable(Project var1, Editor var2, PsiElement var3);

    private static PsiElement getElement(Editor editor, PsiFile file) {
        CaretModel caretModel = editor.getCaretModel();
        int position = caretModel.getOffset();
        return file.findElementAt(position);
    }
}

