/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.moveUpDown;

import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;

public abstract class StatementUpDownMover {
    public static final ExtensionPointName<StatementUpDownMover> STATEMENT_UP_DOWN_MOVER_EP = ExtensionPointName.create((String)"com.intellij.statementUpDownMover");

    public abstract boolean checkAvailable(Editor var1, PsiFile var2, MoveInfo var3, boolean var4);

    public void beforeMove(Editor editor, MoveInfo info, boolean down) {
    }

    public void afterMove(Editor editor, PsiFile file, MoveInfo info, boolean down) {
    }

    public static int getLineStartSafeOffset(Document document, int line) {
        if (line == document.getLineCount()) {
            return document.getTextLength();
        }
        return document.getLineStartOffset(line);
    }

    protected static LineRange getLineRangeFromSelection(Editor editor) {
        LineRange range;
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            int startLine = editor.offsetToLogicalPosition((int)selectionModel.getSelectionStart()).line;
            LogicalPosition endPos = editor.offsetToLogicalPosition(selectionModel.getSelectionEnd());
            int endLine = endPos.column == 0 ? endPos.line : endPos.line + 1;
            range = new LineRange(startLine, endLine);
        } else {
            int startLine = editor.getCaretModel().getLogicalPosition().line;
            int endLine = startLine + 1;
            range = new LineRange(startLine, endLine);
        }
        return range;
    }

    protected static Pair<PsiElement, PsiElement> getElementRange(Editor editor, PsiFile file, LineRange range) {
        int startOffset = editor.logicalPositionToOffset(new LogicalPosition(range.startLine, 0));
        PsiElement startingElement = StatementUpDownMover.firstNonWhiteElement(startOffset, file, true);
        if (startingElement == null) {
            return null;
        }
        int endOffset = editor.logicalPositionToOffset(new LogicalPosition(range.endLine, 0)) - 1;
        PsiElement endingElement = StatementUpDownMover.firstNonWhiteElement(endOffset, file, false);
        if (endingElement == null) {
            return null;
        }
        if (PsiTreeUtil.isAncestor(startingElement, endingElement, false) || startingElement.getTextRange().getEndOffset() <= endingElement.getTextRange().getStartOffset()) {
            return Pair.create((Object)startingElement, (Object)endingElement);
        }
        if (PsiTreeUtil.isAncestor(endingElement, startingElement, false)) {
            return Pair.create((Object)startingElement, (Object)endingElement);
        }
        return null;
    }

    protected static PsiElement firstNonWhiteElement(int offset, PsiFile file, boolean lookRight) {
        ASTNode leafElement = file.getNode().findLeafElementAt(offset);
        return leafElement == null ? null : StatementUpDownMover.firstNonWhiteElement(leafElement.getPsi(), lookRight);
    }

    protected static PsiElement firstNonWhiteElement(PsiElement element, boolean lookRight) {
        if (element instanceof PsiWhiteSpace) {
            element = lookRight ? element.getNextSibling() : element.getPrevSibling();
        }
        return element;
    }

    public static class MoveInfo
    extends UserDataHolderBase {
        public LineRange toMove;
        public LineRange toMove2;
        public RangeMarker range1;
        public RangeMarker range2;
        public boolean indentSource;
        public boolean indentTarget = true;

        public final boolean prohibitMove() {
            this.toMove2 = null;
            return true;
        }
    }
}

