/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;

public abstract class MergeableLineMarkerInfo<T extends PsiElement>
extends LineMarkerInfo<T> {
    public MergeableLineMarkerInfo(T element, TextRange textRange, Icon icon, int updatePass, Function<? super T, String> tooltipProvider, GutterIconNavigationHandler<T> navHandler, GutterIconRenderer.Alignment alignment) {
        super(element, textRange, icon, updatePass, tooltipProvider, navHandler, alignment);
    }

    public abstract boolean canMergeWith(MergeableLineMarkerInfo<?> var1);

    public abstract Icon getCommonIcon(List<MergeableLineMarkerInfo> var1);

    public abstract Function<? super PsiElement, String> getCommonTooltip(List<MergeableLineMarkerInfo> var1);

    public GutterIconRenderer.Alignment getCommonIconAlignment(List<MergeableLineMarkerInfo> infos) {
        return GutterIconRenderer.Alignment.LEFT;
    }

    public int getCommonUpdatePass(List<MergeableLineMarkerInfo> infos) {
        return this.updatePass;
    }

    public boolean configurePopupAndRenderer(PopupChooserBuilder builder, JBList list, List<MergeableLineMarkerInfo> markers) {
        return false;
    }

    public static List<LineMarkerInfo> merge(List<MergeableLineMarkerInfo> markers) {
        SmartList result = new SmartList();
        for (int i = 0; i < markers.size(); ++i) {
            MergeableLineMarkerInfo marker = markers.get(i);
            SmartList toMerge = new SmartList();
            for (int k = markers.size() - 1; k > i; --k) {
                MergeableLineMarkerInfo current = markers.get(k);
                if (!marker.canMergeWith(current)) continue;
                toMerge.add(0, current);
                markers.remove(k);
            }
            if (toMerge.isEmpty()) {
                result.add(marker);
                continue;
            }
            toMerge.add(0, marker);
            result.add(new MyLineMarkerInfo((List<MergeableLineMarkerInfo>)toMerge));
        }
        return result;
    }

    private static class MyLineMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        public MyLineMarkerInfo(List<MergeableLineMarkerInfo> markers) {
            this(markers, markers.get(0));
        }

        private MyLineMarkerInfo(List<MergeableLineMarkerInfo> markers, MergeableLineMarkerInfo template) {
            super(template.getElement(), MyLineMarkerInfo.getCommonTextRange(markers), template.getCommonIcon(markers), template.getCommonUpdatePass(markers), template.getCommonTooltip(markers), MyLineMarkerInfo.getCommonNavigationHandler(markers), template.getCommonIconAlignment(markers));
        }

        private static TextRange getCommonTextRange(List<MergeableLineMarkerInfo> markers) {
            int startOffset = Integer.MAX_VALUE;
            int endOffset = Integer.MIN_VALUE;
            for (MergeableLineMarkerInfo marker : markers) {
                startOffset = Math.min(startOffset, marker.startOffset);
                endOffset = Math.max(endOffset, marker.endOffset);
            }
            return TextRange.create((int)startOffset, (int)endOffset);
        }

        private static GutterIconNavigationHandler<PsiElement> getCommonNavigationHandler(final List<MergeableLineMarkerInfo> markers) {
            return new GutterIconNavigationHandler<PsiElement>(){

                @Override
                public void navigate(final MouseEvent e, PsiElement elt) {
                    ArrayList<MergeableLineMarkerInfo> infos = new ArrayList<MergeableLineMarkerInfo>(markers);
                    Collections.sort(infos, new Comparator<LineMarkerInfo>(){

                        @Override
                        public int compare(LineMarkerInfo o1, LineMarkerInfo o2) {
                            return o1.startOffset - o2.startOffset;
                        }
                    });
                    final JBList list = new JBList(infos);
                    list.setFixedCellHeight(20);
                    PopupChooserBuilder builder = JBPopupFactory.getInstance().createListPopupBuilder(list);
                    if (!((MergeableLineMarkerInfo)markers.get(0)).configurePopupAndRenderer(builder, list, infos)) {
                        list.installCellRenderer(new NotNullFunction<Object, JComponent>(){

                            public JComponent fun(Object dom) {
                                if (dom instanceof LineMarkerInfo) {
                                    Icon icon = null;
                                    GutterIconRenderer renderer = ((LineMarkerInfo)dom).createGutterRenderer();
                                    if (renderer != null) {
                                        icon = renderer.getIcon();
                                    }
                                    Object element = ((LineMarkerInfo)dom).getElement();
                                    assert (element != null);
                                    String text = StringUtil.first((String)element.getText(), (int)100, (boolean)true).replace('\n', ' ');
                                    return new JBLabel(text, icon, 2);
                                }
                                return new JBLabel();
                            }
                        });
                    }
                    builder.setItemChoosenCallback(new Runnable(){

                        @Override
                        public void run() {
                            GutterIconNavigationHandler handler;
                            Object value = list.getSelectedValue();
                            if (value instanceof LineMarkerInfo && (handler = ((LineMarkerInfo)value).getNavigationHandler()) != null) {
                                handler.navigate(e, ((LineMarkerInfo)value).getElement());
                            }
                        }
                    }).createPopup().show(new RelativePoint(e));
                }
            };
        }
    }
}

