/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;

public final class CompletionParameters {
    private final PsiElement myPosition;
    private final PsiFile myOriginalFile;
    private final CompletionType myCompletionType;
    private final Editor myEditor;
    private final int myOffset;
    private final int myInvocationCount;

    CompletionParameters(PsiElement position, PsiFile originalFile, CompletionType completionType, int offset, int invocationCount, Editor editor) {
        assert (position.getTextRange().containsOffset(offset)) : position;
        this.myPosition = position;
        assert (position.isValid());
        this.myOriginalFile = originalFile;
        this.myCompletionType = completionType;
        this.myOffset = offset;
        this.myInvocationCount = invocationCount;
        this.myEditor = editor;
    }

    public CompletionParameters delegateToClassName() {
        return this.withType(CompletionType.CLASS_NAME).withInvocationCount(this.myInvocationCount - 1);
    }

    public CompletionParameters withType(CompletionType type) {
        return new CompletionParameters(this.myPosition, this.myOriginalFile, type, this.myOffset, this.myInvocationCount, this.myEditor);
    }

    public CompletionParameters withInvocationCount(int newCount) {
        return new CompletionParameters(this.myPosition, this.myOriginalFile, this.myCompletionType, this.myOffset, newCount, this.myEditor);
    }

    public PsiElement getPosition() {
        return this.myPosition;
    }

    public PsiElement getOriginalPosition() {
        return this.myOriginalFile.findElementAt(this.myPosition.getTextRange().getStartOffset());
    }

    public PsiFile getOriginalFile() {
        return this.myOriginalFile;
    }

    public CompletionType getCompletionType() {
        return this.myCompletionType;
    }

    public int getOffset() {
        return this.myOffset;
    }

    public int getInvocationCount() {
        return this.myInvocationCount;
    }

    public boolean isAutoPopup() {
        return this.myInvocationCount == 0;
    }

    public CompletionParameters withPosition(PsiElement element, int offset) {
        return new CompletionParameters(element, this.myOriginalFile, this.myCompletionType, offset, this.myInvocationCount, this.myEditor);
    }

    public boolean isExtendedCompletion() {
        return this.myCompletionType == CompletionType.BASIC && this.myInvocationCount >= 2;
    }

    public Editor getEditor() {
        return this.myEditor;
    }
}

