/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;

public abstract class NullableNotNullManager
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)("#" + NullableNotNullManager.class.getName()));
    public String myDefaultNullable = "android.support.annotation.Nullable";
    public String myDefaultNotNull = "android.support.annotation.NonNull";
    public final JDOMExternalizableStringList myNullables = new JDOMExternalizableStringList();
    public final JDOMExternalizableStringList myNotNulls = new JDOMExternalizableStringList();
    private static final String JAVAX_ANNOTATION_NULLABLE = "javax.annotation.Nullable";
    private static final String JAVAX_ANNOTATION_NONNULL = "javax.annotation.Nonnull";
    public static final String[] DEFAULT_NULLABLES = new String[]{"org.jetbrains.annotations.Nullable", "javax.annotation.Nullable", "edu.umd.cs.findbugs.annotations.Nullable", "android.support.annotation.Nullable"};
    public static final String[] DEFAULT_NOT_NULLS = new String[]{"org.jetbrains.annotations.NotNull", "javax.annotation.Nonnull", "edu.umd.cs.findbugs.annotations.NonNull", "android.support.annotation.NonNull"};

    public NullableNotNullManager() {
        Collections.addAll(this.myNotNulls, DEFAULT_NOT_NULLS);
        Collections.addAll(this.myNullables, DEFAULT_NULLABLES);
    }

    public static NullableNotNullManager getInstance(Project project) {
        return ServiceManager.getService(project, NullableNotNullManager.class);
    }

    public boolean hasNullability(PsiModifierListOwner owner) {
        return this.isNullable(owner, false) || this.isNotNull(owner, false);
    }

    private static void addAllIfNotPresent(Collection<String> collection, String ... annotations) {
        for (String annotation : annotations) {
            LOG.assertTrue(annotation != null);
            if (collection.contains(annotation)) continue;
            collection.add(annotation);
        }
    }

    public void setNotNulls(String ... annotations) {
        this.myNotNulls.clear();
        NullableNotNullManager.addAllIfNotPresent((Collection<String>)this.myNotNulls, DEFAULT_NOT_NULLS);
        NullableNotNullManager.addAllIfNotPresent((Collection<String>)this.myNotNulls, annotations);
    }

    public void setNullables(String ... annotations) {
        this.myNullables.clear();
        NullableNotNullManager.addAllIfNotPresent((Collection<String>)this.myNullables, DEFAULT_NULLABLES);
        NullableNotNullManager.addAllIfNotPresent((Collection<String>)this.myNullables, annotations);
    }

    public String getDefaultNullable() {
        return this.myDefaultNullable;
    }

    public String getNullable(PsiModifierListOwner owner) {
        PsiAnnotation annotation = this.getNullableAnnotation(owner, false);
        return annotation == null ? null : annotation.getQualifiedName();
    }

    private String checkContainer(PsiAnnotation annotation, boolean acceptContainer) {
        if (annotation == null) {
            return null;
        }
        if (!acceptContainer && this.isContainerAnnotation(annotation)) {
            return null;
        }
        return annotation.getQualifiedName();
    }

    public PsiAnnotation getNullableAnnotation(PsiModifierListOwner owner, boolean checkBases) {
        return this.findNullabilityAnnotationWithDefault(owner, checkBases, true);
    }

    public boolean isContainerAnnotation(PsiAnnotation anno) {
        PsiAnnotation.TargetType[] acceptAnyTarget = PsiAnnotation.TargetType.values();
        return NullableNotNullManager.isNullabilityDefault(anno, true, acceptAnyTarget) || NullableNotNullManager.isNullabilityDefault(anno, false, acceptAnyTarget);
    }

    public void setDefaultNullable(String defaultNullable) {
        LOG.assertTrue(this.getNullables().contains(defaultNullable));
        this.myDefaultNullable = defaultNullable;
    }

    public String getDefaultNotNull() {
        return this.myDefaultNotNull;
    }

    public PsiAnnotation getNotNullAnnotation(PsiModifierListOwner owner, boolean checkBases) {
        return this.findNullabilityAnnotationWithDefault(owner, checkBases, false);
    }

    public PsiAnnotation copyNotNullAnnotation(PsiModifierListOwner owner) {
        return this.copyAnnotation(owner, this.getNotNullAnnotation(owner, false));
    }

    public PsiAnnotation copyNullableAnnotation(PsiModifierListOwner owner) {
        return this.copyAnnotation(owner, this.getNullableAnnotation(owner, false));
    }

    private PsiAnnotation copyAnnotation(PsiModifierListOwner owner, PsiAnnotation annotation) {
        String notNull = this.checkContainer(annotation, false);
        if (notNull != null) {
            return JavaPsiFacade.getElementFactory(owner.getProject()).createAnnotationFromText("@" + notNull, owner);
        }
        return null;
    }

    public String getNotNull(PsiModifierListOwner owner) {
        PsiAnnotation annotation = this.getNotNullAnnotation(owner, false);
        return annotation == null ? null : annotation.getQualifiedName();
    }

    public void setDefaultNotNull(String defaultNotNull) {
        LOG.assertTrue(this.getNotNulls().contains(defaultNotNull));
        this.myDefaultNotNull = defaultNotNull;
    }

    private PsiAnnotation findNullabilityAnnotationWithDefault(PsiModifierListOwner owner, boolean checkBases, boolean nullable) {
        PsiAnnotation annotation = this.findPlainNullabilityAnnotation(owner, checkBases);
        if (annotation != null) {
            List<String> contradictory;
            String qName = annotation.getQualifiedName();
            if (qName == null) {
                return null;
            }
            List<String> list = contradictory = nullable ? this.getNotNulls() : this.getNullables();
            if (contradictory.contains(qName)) {
                return null;
            }
            return annotation;
        }
        PsiType type = NullableNotNullManager.getOwnerType(owner);
        if (type == null || TypeConversionUtil.isPrimitiveAndNotNull(type)) {
            return null;
        }
        if (AnnotationUtil.isAnnotated(owner, nullable ? Arrays.asList(DEFAULT_NOT_NULLS) : Arrays.asList(DEFAULT_NULLABLES), checkBases, false)) {
            return null;
        }
        if (!nullable && this.hasHardcodedContracts(owner)) {
            return null;
        }
        return NullableNotNullManager.findNullabilityDefaultInHierarchy(owner, nullable);
    }

    private PsiAnnotation findPlainNullabilityAnnotation(PsiModifierListOwner owner, boolean checkBases) {
        HashSet qNames = ContainerUtil.newHashSet(this.getNullables());
        qNames.addAll(this.getNotNulls());
        return checkBases && owner instanceof PsiMethod ? AnnotationUtil.findAnnotationInHierarchy(owner, qNames) : AnnotationUtil.findAnnotation(owner, qNames);
    }

    protected boolean hasHardcodedContracts(PsiElement element) {
        return false;
    }

    private static PsiType getOwnerType(PsiModifierListOwner owner) {
        if (owner instanceof PsiVariable) {
            return ((PsiVariable)owner).getType();
        }
        if (owner instanceof PsiMethod) {
            return ((PsiMethod)owner).getReturnType();
        }
        return null;
    }

    public boolean isNullable(PsiModifierListOwner owner, boolean checkBases) {
        return this.findNullabilityAnnotationWithDefault(owner, checkBases, true) != null;
    }

    public boolean isNotNull(PsiModifierListOwner owner, boolean checkBases) {
        return this.findNullabilityAnnotationWithDefault(owner, checkBases, false) != null;
    }

    private static PsiAnnotation findNullabilityDefaultInHierarchy(PsiModifierListOwner owner, boolean nullable) {
        PsiAnnotation.TargetType[] placeTargetTypes = AnnotationTargetUtil.getTargetsForLocation(owner.getModifierList());
        for (PsiElement element = owner.getParent(); element != null; element = element.getContext()) {
            PsiAnnotation annotation;
            if (element instanceof PsiModifierListOwner && (annotation = NullableNotNullManager.getNullabilityDefault((PsiModifierListOwner)element, nullable, placeTargetTypes)) != null) {
                return annotation;
            }
            if (!(element instanceof PsiClassOwner)) continue;
            String packageName = ((PsiClassOwner)element).getPackageName();
            PsiPackage psiPackage = JavaPsiFacade.getInstance(element.getProject()).findPackage(packageName);
            return psiPackage == null ? null : NullableNotNullManager.getNullabilityDefault(psiPackage, nullable, placeTargetTypes);
        }
        return null;
    }

    private static PsiAnnotation getNullabilityDefault(PsiModifierListOwner container, boolean nullable, PsiAnnotation.TargetType[] placeTargetTypes) {
        PsiModifierList modifierList = container.getModifierList();
        if (modifierList == null) {
            return null;
        }
        for (PsiAnnotation annotation : modifierList.getAnnotations()) {
            if (!NullableNotNullManager.isNullabilityDefault(annotation, nullable, placeTargetTypes)) continue;
            return annotation;
        }
        return null;
    }

    private static boolean isNullabilityDefault(PsiAnnotation annotation, boolean nullable, PsiAnnotation.TargetType[] placeTargetTypes) {
        PsiElement declaration;
        PsiJavaCodeReferenceElement element = annotation.getNameReferenceElement();
        PsiElement psiElement = declaration = element == null ? null : element.resolve();
        if (!(declaration instanceof PsiClass)) {
            return false;
        }
        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiClass)declaration), nullable ? JAVAX_ANNOTATION_NULLABLE : JAVAX_ANNOTATION_NONNULL, false, true)) {
            return false;
        }
        PsiAnnotation tqDefault = AnnotationUtil.findAnnotation((PsiModifierListOwner)((PsiClass)declaration), true, "javax.annotation.meta.TypeQualifierDefault");
        if (tqDefault == null) {
            return false;
        }
        Set<PsiAnnotation.TargetType> required = AnnotationTargetUtil.extractRequiredAnnotationTargets(tqDefault.findAttributeValue(null));
        if (required == null) {
            return false;
        }
        return required.isEmpty() || ContainerUtil.intersects(required, Arrays.asList(placeTargetTypes));
    }

    public List<String> getNullables() {
        return this.myNullables;
    }

    public List<String> getNotNulls() {
        return this.myNotNulls;
    }

    public boolean hasDefaultValues() {
        int i;
        if (DEFAULT_NULLABLES.length != this.getNullables().size() || DEFAULT_NOT_NULLS.length != this.getNotNulls().size()) {
            return false;
        }
        if (!this.myDefaultNotNull.equals("org.jetbrains.annotations.NotNull") || !this.myDefaultNullable.equals("org.jetbrains.annotations.Nullable")) {
            return false;
        }
        for (i = 0; i < DEFAULT_NULLABLES.length; ++i) {
            if (this.getNullables().get(i).equals(DEFAULT_NULLABLES[i])) continue;
            return false;
        }
        for (i = 0; i < DEFAULT_NOT_NULLS.length; ++i) {
            if (this.getNotNulls().get(i).equals(DEFAULT_NOT_NULLS[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Element getState() {
        Element component = new Element("component");
        if (this.hasDefaultValues()) {
            return component;
        }
        try {
            DefaultJDOMExternalizer.writeExternal((Object)this, (Element)component);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        return component;
    }

    @Override
    public void loadState(Element state) {
        try {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)state);
            if (this.myNullables.isEmpty()) {
                Collections.addAll(this.myNullables, DEFAULT_NULLABLES);
            }
            if (this.myNotNulls.isEmpty()) {
                Collections.addAll(this.myNotNulls, DEFAULT_NOT_NULLS);
            }
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    public static boolean isNullable(PsiModifierListOwner owner) {
        return NullableNotNullManager.getInstance(owner.getProject()).isNullable(owner, true);
    }

    public static boolean isNotNull(PsiModifierListOwner owner) {
        return NullableNotNullManager.getInstance(owner.getProject()).isNotNull(owner, true);
    }
}

