/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util.importProject;

import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectFromSourcesBuilder;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.ide.util.projectWizard.importSources.impl.JavaProjectStructureDetector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.util.CloudGitDeploymentDetector;
import com.intellij.remoteServer.util.importProject.CloudGitChooseAccountStepImpl;
import com.intellij.remoteServer.util.importProject.CloudGitJavaSourceRoot;
import com.intellij.remoteServer.util.importProject.CloudGitProjectRoot;
import git4idea.GitPlatformFacade;
import git4idea.GitUtil;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class CloudGitProjectStructureDetector
extends ProjectStructureDetector {
    private final JavaProjectStructureDetector myJavaDetector = new JavaProjectStructureDetector();

    public ProjectStructureDetector.DirectoryProcessingResult detectRoots(File dir, File[] children, File base, List<DetectedProjectRoot> result) {
        CloudGitProjectStructureDetector.detectApplicationRoot(dir, result);
        for (DetectedProjectRoot projectRoot : result) {
            if (!(projectRoot instanceof CloudGitProjectRoot) || !FileUtil.isAncestor((File)projectRoot.getDirectory(), (File)dir, (boolean)true)) continue;
            return this.detectJavaRoots(((CloudGitProjectRoot)projectRoot).getJavaSourceRootTypeName(), dir, children, base, result);
        }
        return ProjectStructureDetector.DirectoryProcessingResult.PROCESS_CHILDREN;
    }

    private static void detectApplicationRoot(File dir, List<DetectedProjectRoot> result) {
        VirtualFile repositoryRoot = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(dir);
        if (repositoryRoot == null) {
            return;
        }
        if (GitUtil.findGitDir((VirtualFile)repositoryRoot) == null) {
            return;
        }
        Project project = ProjectManager.getInstance().getDefaultProject();
        GitRepository repository = GitRepositoryImpl.getLightInstance((VirtualFile)repositoryRoot, (Project)project, (GitPlatformFacade)((GitPlatformFacade)ServiceManager.getService((Project)project, GitPlatformFacade.class)), (Disposable)project);
        repository.update();
        for (CloudGitDeploymentDetector deploymentDetector : (CloudGitDeploymentDetector[])CloudGitDeploymentDetector.EP_NAME.getExtensions()) {
            String applicationName = deploymentDetector.getFirstApplicationName(repository);
            if (applicationName == null) continue;
            result.add(new CloudGitProjectRoot(deploymentDetector, dir, repositoryRoot, applicationName));
        }
    }

    private ProjectStructureDetector.DirectoryProcessingResult detectJavaRoots(String javaSourceRootTypeName, File dir, File[] children, File base, List<DetectedProjectRoot> result) {
        ArrayList detectedJavaRoots = new ArrayList();
        ProjectStructureDetector.DirectoryProcessingResult processingResult = this.myJavaDetector.detectRoots(dir, children, base, detectedJavaRoots);
        for (DetectedProjectRoot detectedJavaRoot : detectedJavaRoots) {
            if (!(detectedJavaRoot instanceof JavaModuleSourceRoot)) continue;
            result.add((DetectedProjectRoot)new CloudGitJavaSourceRoot(javaSourceRootTypeName, (JavaModuleSourceRoot)detectedJavaRoot));
        }
        return processingResult;
    }

    public List<ModuleWizardStep> createWizardSteps(ProjectFromSourcesBuilder builder, ProjectDescriptor projectDescriptor, Icon stepIcon) {
        ArrayList<ModuleWizardStep> result = new ArrayList<ModuleWizardStep>();
        for (CloudGitDeploymentDetector deploymentDetector : (CloudGitDeploymentDetector[])CloudGitDeploymentDetector.EP_NAME.getExtensions()) {
            result.add(new CloudGitChooseAccountStepImpl(deploymentDetector, this, builder, projectDescriptor));
        }
        return result;
    }
}

