/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.git4idea.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

public class ScriptGenerator {
    public static final String SCRIPT_EXT = SystemInfo.isWindows ? ".bat" : ".sh";
    private final String myPrefix;
    private final Class myMainClass;
    private final ArrayList<String> myPaths = new ArrayList();
    private final ArrayList<String> myInternalParameters = new ArrayList();

    public ScriptGenerator(String prefix, Class mainClass) {
        this.myPrefix = prefix;
        this.myMainClass = mainClass;
        this.addClasses(this.myMainClass);
    }

    public ScriptGenerator addClasses(Class ... classes) {
        for (Class c : classes) {
            this.addPath(PathUtil.getJarPathForClass((Class)c));
        }
        return this;
    }

    private void addPath(String path) {
        if (!this.myPaths.contains(path)) {
            this.myPaths.add(path);
        }
    }

    public ScriptGenerator addResource(Class base, String resource) {
        this.addPath(ScriptGenerator.getJarForResource(base, resource));
        return this;
    }

    public ScriptGenerator addInternal(String ... parameters) {
        ContainerUtil.addAll(this.myInternalParameters, (Object[])parameters);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File generate() throws IOException {
        File scriptPath = FileUtil.createTempFile((String)this.myPrefix, (String)SCRIPT_EXT);
        scriptPath.deleteOnExit();
        PrintWriter out = new PrintWriter(new FileWriter(scriptPath));
        try {
            if (SystemInfo.isWindows) {
                out.println("@echo off");
            } else {
                out.println("#!/bin/sh");
            }
            String line = this.commandLine();
            line = SystemInfo.isWindows ? line + " %*" : line + " \"$@\"";
            out.println(line);
        }
        finally {
            out.close();
        }
        FileUtil.setExecutableAttribute((String)scriptPath.getPath(), (boolean)true);
        return scriptPath;
    }

    public String commandLine() {
        StringBuilder cmd = new StringBuilder();
        cmd.append('\"').append(System.getProperty("java.home")).append(File.separatorChar).append("bin").append(File.separatorChar).append("java\" -cp \"");
        boolean first = true;
        for (String p : this.myPaths) {
            if (!first) {
                cmd.append(File.pathSeparatorChar);
            } else {
                first = false;
            }
            cmd.append(p);
        }
        cmd.append("\" ");
        cmd.append(this.myMainClass.getName());
        for (String p : this.myInternalParameters) {
            cmd.append(' ');
            cmd.append(p);
        }
        String line = cmd.toString();
        if (SystemInfo.isWindows) {
            line = line.replace('\\', '/');
        }
        return line;
    }

    public static String getJarForResource(Class context, String res) {
        String resourceRoot = PathManager.getResourceRoot((Class)context, (String)res);
        return new File(resourceRoot).getAbsoluteFile().getAbsolutePath();
    }
}

