/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.git4idea.ssh;

import com.intellij.ide.XmlRpcServer;
import com.intellij.openapi.util.io.FileUtilRt;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import org.apache.commons.codec.DecoderException;
import org.apache.xmlrpc.XmlRpcClientLite;
import org.jetbrains.git4idea.GitExternalApp;
import org.jetbrains.git4idea.util.ScriptGenerator;
import org.jetbrains.ide.BuiltInServerManager;

public abstract class GitXmlRpcHandlerService<T> {
    private final String myScriptTempFilePrefix;
    private final String myHandlerName;
    private final Class<? extends GitExternalApp> myScriptMainClass;
    private File myScriptPath;
    private final Object SCRIPT_FILE_LOCK = new Object();
    private final THashMap<Integer, T> handlers = new THashMap();
    private int myNextHandlerKey;
    private final Object HANDLERS_LOCK = new Object();

    protected GitXmlRpcHandlerService(String prefix, String handlerName, Class<? extends GitExternalApp> aClass) {
        this.myScriptTempFilePrefix = prefix;
        this.myHandlerName = handlerName;
        this.myScriptMainClass = aClass;
    }

    public int getXmlRcpPort() {
        return BuiltInServerManager.getInstance().waitForStart().getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getScriptPath() throws IOException {
        ScriptGenerator generator = new ScriptGenerator(this.myScriptTempFilePrefix, this.myScriptMainClass);
        generator.addClasses(XmlRpcClientLite.class, DecoderException.class, FileUtilRt.class);
        this.customizeScriptGenerator(generator);
        Object object = this.SCRIPT_FILE_LOCK;
        synchronized (object) {
            if (this.myScriptPath == null || !this.myScriptPath.exists()) {
                this.myScriptPath = generator.generate();
            }
            return this.myScriptPath;
        }
    }

    protected abstract void customizeScriptGenerator(ScriptGenerator var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerHandler(T handler) {
        Object object = this.HANDLERS_LOCK;
        synchronized (object) {
            XmlRpcServer xmlRpcServer = XmlRpcServer.SERVICE.getInstance();
            if (!xmlRpcServer.hasHandler(this.myHandlerName)) {
                xmlRpcServer.addHandler(this.myHandlerName, this.createRpcRequestHandlerDelegate());
            }
            int key = this.myNextHandlerKey++;
            this.handlers.put((Object)key, handler);
            return key;
        }
    }

    protected abstract Object createRpcRequestHandlerDelegate();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T getHandler(int key) {
        Object object = this.HANDLERS_LOCK;
        synchronized (object) {
            Object rc = this.handlers.get((Object)key);
            if (rc == null) {
                throw new IllegalStateException("No handler for the key " + key);
            }
            return (T)rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterHandler(int key) {
        Object object = this.HANDLERS_LOCK;
        synchronized (object) {
            if (this.handlers.remove((Object)key) == null) {
                throw new IllegalArgumentException("The handler " + key + " is not registered");
            }
        }
    }
}

