/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchPair;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.config.GitConfigUtil;
import git4idea.config.UpdateMethod;
import git4idea.merge.MergeChangeCollector;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitMergeUpdater;
import git4idea.update.GitRebaseUpdater;
import git4idea.update.GitUpdateResult;
import java.util.ArrayList;
import java.util.Map;

public abstract class GitUpdater {
    private static final Logger LOG = Logger.getInstance(GitUpdater.class);
    protected final Project myProject;
    protected final Git myGit;
    protected final VirtualFile myRoot;
    protected final Map<VirtualFile, GitBranchPair> myTrackedBranches;
    protected final ProgressIndicator myProgressIndicator;
    protected final UpdatedFiles myUpdatedFiles;
    protected final AbstractVcsHelper myVcsHelper;
    protected final GitRepositoryManager myRepositoryManager;
    protected final GitVcs myVcs;
    protected GitRevisionNumber myBefore;

    protected GitUpdater(Project project, Git git, VirtualFile root, Map<VirtualFile, GitBranchPair> trackedBranches, ProgressIndicator progressIndicator, UpdatedFiles updatedFiles) {
        this.myProject = project;
        this.myGit = git;
        this.myRoot = root;
        this.myTrackedBranches = trackedBranches;
        this.myProgressIndicator = progressIndicator;
        this.myUpdatedFiles = updatedFiles;
        this.myVcsHelper = AbstractVcsHelper.getInstance((Project)project);
        this.myVcs = GitVcs.getInstance(project);
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
    }

    public static GitUpdater getUpdater(Project project, Git git, Map<VirtualFile, GitBranchPair> trackedBranches, VirtualFile root, ProgressIndicator progressIndicator, UpdatedFiles updatedFiles, UpdateMethod updateMethod) {
        if (updateMethod == UpdateMethod.BRANCH_DEFAULT) {
            updateMethod = GitUpdater.resolveUpdateMethod(project, root);
        }
        return updateMethod == UpdateMethod.REBASE ? new GitRebaseUpdater(project, git, root, trackedBranches, progressIndicator, updatedFiles) : new GitMergeUpdater(project, git, root, trackedBranches, progressIndicator, updatedFiles);
    }

    public static UpdateMethod resolveUpdateMethod(Project project, VirtualFile root) {
        GitLocalBranch branch = GitBranchUtil.getCurrentBranch(project, root);
        boolean rebase = false;
        if (branch != null) {
            try {
                String rebaseValue = GitConfigUtil.getValue(project, root, "branch." + branch.getName() + ".rebase");
                rebase = rebaseValue != null && rebaseValue.equalsIgnoreCase("true");
            }
            catch (VcsException e) {
                LOG.warn("Couldn't get git config branch." + branch.getName() + ".rebase", (Throwable)e);
            }
        }
        return rebase ? UpdateMethod.REBASE : UpdateMethod.MERGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GitUpdateResult update() throws VcsException {
        this.markStart(this.myRoot);
        try {
            GitUpdateResult gitUpdateResult = this.doUpdate();
            return gitUpdateResult;
        }
        finally {
            this.markEnd(this.myRoot);
        }
    }

    public abstract boolean isSaveNeeded();

    public boolean isUpdateNeeded() throws VcsException {
        GitBranchPair gitBranchPair = this.myTrackedBranches.get(this.myRoot);
        String currentBranch = gitBranchPair.getBranch().getName();
        GitRemoteBranch dest = gitBranchPair.getDest();
        assert (dest != null);
        String remoteBranch = dest.getName();
        if (!this.hasRemoteChanges(currentBranch, remoteBranch)) {
            LOG.info("isSaveNeeded No remote changes, save is not needed");
            return false;
        }
        return true;
    }

    protected abstract GitUpdateResult doUpdate();

    GitBranchPair getSourceAndTarget() {
        return this.myTrackedBranches.get(this.myRoot);
    }

    protected void markStart(VirtualFile root) throws VcsException {
        this.myBefore = GitRevisionNumber.resolve(this.myProject, root, "HEAD");
    }

    protected void markEnd(VirtualFile root) throws VcsException {
        MergeChangeCollector collector = new MergeChangeCollector(this.myProject, root, this.myBefore);
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        collector.collect(this.myUpdatedFiles, exceptions);
        if (!exceptions.isEmpty()) {
            throw exceptions.get(0);
        }
    }

    protected boolean hasRemoteChanges(String currentBranch, String remoteBranch) throws VcsException {
        GitSimpleHandler handler = new GitSimpleHandler(this.myProject, this.myRoot, GitCommand.REV_LIST);
        handler.setSilent(true);
        handler.addParameters("-1");
        handler.addParameters(currentBranch + ".." + remoteBranch);
        String output = handler.run();
        return output != null && !output.isEmpty();
    }

    protected String makeProgressTitle(String operation) {
        return this.myRepositoryManager.moreThanOneRoot() ? String.format("%s %s...", operation, this.myRoot.getName()) : operation + "...";
    }
}

