/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.branch.DvcsMultiRootBranchConfig;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchUtil;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class GitMultiRootBranchConfig
extends DvcsMultiRootBranchConfig<GitRepository> {
    public GitMultiRootBranchConfig(Collection<GitRepository> repositories) {
        super(repositories);
    }

    public Collection<String> getLocalBranchNames() {
        return GitBranchUtil.getCommonBranches(this.myRepositories, true);
    }

    Collection<String> getRemoteBranches() {
        return GitBranchUtil.getCommonBranches(this.myRepositories, false);
    }

    public String getTrackedBranch(String branch) {
        String trackedName = null;
        for (GitRepository repository : this.myRepositories) {
            GitRemoteBranch tracked = GitMultiRootBranchConfig.getTrackedBranch(repository, branch);
            if (tracked == null) {
                return null;
            }
            if (trackedName == null) {
                trackedName = tracked.getNameForLocalOperations();
                continue;
            }
            if (trackedName.equals(tracked.getNameForLocalOperations())) continue;
            return null;
        }
        return trackedName;
    }

    public Collection<String> getTrackingBranches(String remoteBranch) {
        Collection trackingBranches = null;
        for (GitRepository repository : this.myRepositories) {
            Collection tb = GitMultiRootBranchConfig.getTrackingBranches(repository, remoteBranch);
            if (trackingBranches == null) {
                trackingBranches = tb;
                continue;
            }
            trackingBranches = ContainerUtil.intersection(trackingBranches, tb);
        }
        return trackingBranches == null ? Collections.emptyList() : trackingBranches;
    }

    public static Collection<String> getTrackingBranches(GitRepository repository, String remoteBranch) {
        ArrayList<String> trackingBranches = new ArrayList<String>(1);
        for (GitBranchTrackInfo trackInfo : repository.getBranchTrackInfos()) {
            if (!remoteBranch.equals(trackInfo.getRemote().getName() + "/" + trackInfo.getRemoteBranch())) continue;
            trackingBranches.add(trackInfo.getLocalBranch().getName());
        }
        return trackingBranches;
    }

    private static GitRemoteBranch getTrackedBranch(GitRepository repository, String branchName) {
        GitLocalBranch branch = repository.getBranches().findLocalBranch(branchName);
        return branch == null ? null : branch.findTrackedBranch(repository);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (GitRepository repository : this.myRepositories) {
            sb.append(repository.getPresentableUrl()).append(":").append(repository.getCurrentBranch()).append(":").append(repository.getState());
        }
        return sb.toString();
    }
}

