/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.util.Consumer;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.ui.branch.GitBranchPopup;
import java.awt.event.MouseEvent;

public class GitBranchWidget
extends EditorBasedWidget
implements StatusBarWidget.MultipleTextValuesPresentation,
StatusBarWidget.Multiframe,
GitRepositoryChangeListener {
    private static final Logger LOG = Logger.getInstance(GitBranchWidget.class);
    private final GitVcsSettings mySettings;
    private volatile String myText = "";
    private volatile String myTooltip = "";
    private final String myMaxString;

    public GitBranchWidget(Project project) {
        super(project);
        project.getMessageBus().connect().subscribe(GitRepository.GIT_REPO_CHANGE, (Object)this);
        this.mySettings = GitVcsSettings.getInstance(project);
        this.myMaxString = "Git: Rebasing master";
        this.updateLater();
    }

    public StatusBarWidget copy() {
        return new GitBranchWidget(this.getProject());
    }

    public String ID() {
        return GitBranchWidget.class.getName();
    }

    public StatusBarWidget.WidgetPresentation getPresentation(StatusBarWidget.PlatformType type) {
        return this;
    }

    public void selectionChanged(FileEditorManagerEvent event) {
        LOG.debug("selection changed");
        this.update();
    }

    public void fileOpened(FileEditorManager source, VirtualFile file) {
        LOG.debug("file opened");
        this.update();
    }

    public void fileClosed(FileEditorManager source, VirtualFile file) {
        LOG.debug("file closed");
        this.update();
    }

    @Override
    public void repositoryChanged(GitRepository repository) {
        LOG.debug("repository changed");
        this.updateLater();
    }

    private void updateLater() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                LOG.debug("update after repository change");
                GitBranchWidget.this.update();
            }
        });
    }

    public ListPopup getPopupStep() {
        Project project = this.getProject();
        if (project == null) {
            return null;
        }
        GitRepository repo = GitBranchUtil.getCurrentRepository(project);
        if (repo == null) {
            return null;
        }
        this.update();
        return GitBranchPopup.getInstance(project, repo).asListPopup();
    }

    public String getSelectedValue() {
        String text = this.myText;
        return StringUtil.isEmpty((String)text) ? "" : "Git: " + text;
    }

    @Deprecated
    public String getMaxValue() {
        return this.myMaxString;
    }

    public String getTooltipText() {
        return this.myTooltip;
    }

    public Consumer<MouseEvent> getClickConsumer() {
        return new Consumer<MouseEvent>(){

            public void consume(MouseEvent mouseEvent) {
                GitBranchWidget.this.update();
            }
        };
    }

    private void update() {
        Project project = this.getProject();
        if (project == null || project.isDisposed()) {
            this.emptyTextAndTooltip();
            return;
        }
        GitRepository repo = GitBranchUtil.getCurrentRepository(project);
        if (repo == null) {
            this.emptyTextAndTooltip();
            return;
        }
        int maxLength = this.myMaxString.length() - 1;
        this.myText = StringUtil.shortenTextWithEllipsis((String)GitBranchUtil.getDisplayableBranchText(repo), (int)maxLength, (int)5);
        this.myTooltip = GitBranchWidget.getDisplayableBranchTooltip(repo);
        this.myStatusBar.updateWidget(this.ID());
        this.mySettings.setRecentRoot(repo.getRoot().getPath());
    }

    private void emptyTextAndTooltip() {
        this.myText = "";
        this.myTooltip = "";
    }

    private static String getDisplayableBranchTooltip(GitRepository repo) {
        String text = GitBranchUtil.getDisplayableBranchText(repo);
        if (!GitUtil.justOneGitRepository(repo.getProject())) {
            return text + "\n" + "Root: " + repo.getRoot().getName();
        }
        return text;
    }
}

