/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.LocalChangesUnderRoots;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.continuation.ContinuationContext;
import git4idea.GitPlatformFacade;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandlerUtil;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.merge.GitConflictResolver;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.stash.GitChangesSaver;
import git4idea.stash.GitStashUtils;
import git4idea.ui.GitUnstashDialog;
import git4idea.util.GitUIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;

public class GitStashChangesSaver
extends GitChangesSaver {
    private static final Logger LOG = Logger.getInstance(GitStashChangesSaver.class);
    private final Set<VirtualFile> myStashedRoots = new HashSet<VirtualFile>();
    private final GitRepositoryManager myRepositoryManager;

    public GitStashChangesSaver(Project project, GitPlatformFacade platformFacade, Git git, ProgressIndicator progressIndicator, String stashMessage) {
        super(project, platformFacade, git, progressIndicator, stashMessage);
        this.myRepositoryManager = (GitRepositoryManager)((Object)platformFacade.getRepositoryManager(project));
    }

    @Override
    protected void save(Collection<VirtualFile> rootsToSave) throws VcsException {
        LOG.info("save " + rootsToSave);
        Map changes = new LocalChangesUnderRoots((ChangeListManager)this.myChangeManager, this.myPlatformFacade.getVcsManager(this.myProject)).getChangesUnderRoots(rootsToSave);
        this.stash(changes.keySet());
    }

    @Override
    protected void load(ContinuationContext context) {
        try {
            this.load();
        }
        catch (VcsException e) {
            context.handleException((Exception)((Object)e), false);
        }
    }

    public void load() throws VcsException {
        for (VirtualFile root : this.myStashedRoots) {
            this.loadRoot(root);
        }
        boolean conflictsResolved = new UnstashConflictResolver(this.myProject, this.myPlatformFacade, this.myGit, this.myStashedRoots, this.myParams).merge();
        LOG.info("load: conflicts resolved status is " + conflictsResolved + " in roots " + this.myStashedRoots);
    }

    @Override
    protected boolean wereChangesSaved() {
        return !this.myStashedRoots.isEmpty();
    }

    @Override
    public String getSaverName() {
        return "stash";
    }

    @Override
    protected void showSavedChanges() {
        GitUnstashDialog.showUnstashDialog(this.myProject, new ArrayList<VirtualFile>(this.myStashedRoots), this.myStashedRoots.iterator().next());
    }

    @Override
    public void refresh() {
        LocalFileSystem.getInstance().refreshIoFiles((Iterable)this.myChangeManager.getAffectedPaths());
    }

    private void stash(Collection<VirtualFile> roots) throws VcsException {
        for (VirtualFile root : roots) {
            String message = GitHandlerUtil.formatOperationName("Stashing changes from", root);
            LOG.info(message);
            String oldProgressTitle = this.myProgressIndicator.getText();
            this.myProgressIndicator.setText(message);
            GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
            if (repository == null) {
                LOG.error("Repository is null for root " + root);
            } else if (GitStashUtils.saveStash(this.myGit, repository, this.myStashMessage)) {
                this.myStashedRoots.add(root);
            }
            this.myProgressIndicator.setText(oldProgressTitle);
        }
    }

    private boolean loadRoot(VirtualFile root) throws VcsException {
        LOG.info("loadRoot " + root);
        this.myProgressIndicator.setText(GitHandlerUtil.formatOperationName("Unstashing changes to", root));
        GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
        if (repository == null) {
            LOG.error("Repository is null for root " + root);
            return false;
        }
        GitSimpleEventDetector conflictDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.MERGE_CONFLICT_ON_UNSTASH);
        GitCommandResult result = this.myGit.stashPop(repository, conflictDetector);
        if (result.success()) {
            return false;
        }
        if (conflictDetector.hasHappened()) {
            return true;
        }
        LOG.info("unstash failed " + result.getErrorOutputAsJoinedString());
        GitUIUtil.notifyImportantError(this.myProject, "Couldn't unstash", "<br/>" + result.getErrorOutputAsHtmlString());
        return false;
    }

    private static class UnstashMergeDialogCustomizer
    extends MergeDialogCustomizer {
        private UnstashMergeDialogCustomizer() {
        }

        public String getMultipleFileMergeDescription(Collection<VirtualFile> files) {
            return "Uncommitted changes that were stashed before update have conflicts with updated files.";
        }

        public String getLeftPanelTitle(VirtualFile file) {
            return GitChangesSaver.getConflictLeftPanelTitle();
        }

        public String getRightPanelTitle(VirtualFile file, VcsRevisionNumber lastRevisionNumber) {
            return GitChangesSaver.getConflictRightPanelTitle();
        }
    }

    private static class UnstashConflictResolver
    extends GitConflictResolver {
        private final Set<VirtualFile> myStashedRoots;

        public UnstashConflictResolver(Project project, GitPlatformFacade platformFacade, Git git, Set<VirtualFile> stashedRoots, GitConflictResolver.Params params) {
            super(project, git, platformFacade, stashedRoots, UnstashConflictResolver.makeParamsOrUse(params));
            this.myStashedRoots = stashedRoots;
        }

        private static GitConflictResolver.Params makeParamsOrUse(GitConflictResolver.Params givenParams) {
            if (givenParams != null) {
                return givenParams;
            }
            GitConflictResolver.Params params = new GitConflictResolver.Params();
            params.setErrorNotificationTitle("Local changes were not restored");
            params.setMergeDialogCustomizer(new UnstashMergeDialogCustomizer());
            params.setReverse(true);
            return params;
        }

        @Override
        protected void notifyUnresolvedRemain() {
            VcsNotifier.getInstance((Project)this.myProject).notifyImportantWarning("Local changes were restored with conflicts", "Your uncommitted changes were saved to <a href='saver'>stash</a>.<br/>Unstash is not complete, you have unresolved merges in your working tree<br/><a href='resolve'>Resolve</a> conflicts and drop the stash.", new NotificationListener(){

                public void hyperlinkUpdate(Notification notification, HyperlinkEvent event) {
                    if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        if (event.getDescription().equals("saver")) {
                            GitUnstashDialog.showUnstashDialog(UnstashConflictResolver.this.myProject, new ArrayList<VirtualFile>(UnstashConflictResolver.this.myStashedRoots), (VirtualFile)UnstashConflictResolver.this.myStashedRoots.iterator().next());
                        } else if (event.getDescription().equals("resolve")) {
                            UnstashConflictResolver.this.mergeNoProceed();
                        }
                    }
                }
            });
        }
    }
}

