/*
 * Decompiled with CFR 0.152.
 */
package git4idea.reset;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import git4idea.GitPlatformFacade;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUiHandlerImpl;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import git4idea.util.GitPreservingProcess;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GitResetOperation {
    private final Project myProject;
    private final Map<GitRepository, VcsFullCommitDetails> myCommits;
    private final GitResetMode myMode;
    private final ProgressIndicator myIndicator;
    private final Git myGit;
    private final VcsNotifier myNotifier;
    private final GitPlatformFacade myFacade;
    private final GitBranchUiHandlerImpl myUiHandler;

    public GitResetOperation(Project project, Map<GitRepository, VcsFullCommitDetails> targetCommits, GitResetMode mode, ProgressIndicator indicator) {
        this.myProject = project;
        this.myCommits = targetCommits;
        this.myMode = mode;
        this.myIndicator = indicator;
        this.myGit = (Git)ServiceManager.getService(Git.class);
        this.myNotifier = VcsNotifier.getInstance((Project)project);
        this.myFacade = (GitPlatformFacade)ServiceManager.getService(GitPlatformFacade.class);
        this.myUiHandler = new GitBranchUiHandlerImpl(this.myProject, this.myFacade, this.myGit, indicator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        GitResetOperation.saveAllDocuments();
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)this.myProject);
        HashMap results = ContainerUtil.newHashMap();
        try {
            for (Map.Entry<GitRepository, VcsFullCommitDetails> entry : this.myCommits.entrySet()) {
                GitCommandResult smartResult;
                GitLocalChangesWouldBeOverwrittenDetector detector;
                GitRepository repository = entry.getKey();
                VirtualFile root = repository.getRoot();
                String target = ((Hash)entry.getValue().getId()).asString();
                GitCommandResult result = this.myGit.reset(repository, this.myMode, target, detector = new GitLocalChangesWouldBeOverwrittenDetector(root, GitLocalChangesWouldBeOverwrittenDetector.Operation.RESET));
                if (!result.success() && detector.wasMessageDetected() && (smartResult = this.proposeSmartReset(detector, repository, target)) != null) {
                    result = smartResult;
                }
                results.put(repository, result);
                repository.update();
                VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{root});
                VcsDirtyScopeManager.getInstance((Project)this.myProject).dirDirtyRecursively(root);
            }
        }
        finally {
            DvcsUtil.workingTreeChangeFinished((Project)this.myProject, (AccessToken)token);
        }
        this.notifyResult(results);
    }

    private GitCommandResult proposeSmartReset(GitLocalChangesWouldBeOverwrittenDetector detector, final GitRepository repository, final String target) {
        Collection<String> absolutePaths = GitUtil.toAbsolute(repository.getRoot(), detector.getRelativeFilePaths());
        List<Change> affectedChanges = GitUtil.findLocalChangesForPaths(this.myProject, repository.getRoot(), absolutePaths, false);
        int choice = this.myUiHandler.showSmartOperationDialog(this.myProject, affectedChanges, absolutePaths, "reset", "&Hard Reset");
        if (choice == 0) {
            final Ref result = Ref.create();
            new GitPreservingProcess(this.myProject, this.myFacade, this.myGit, Collections.singleton(repository), "reset", target, this.myIndicator, new Runnable(){

                @Override
                public void run() {
                    result.set((Object)GitResetOperation.this.myGit.reset(repository, GitResetOperation.this.myMode, target, new GitLineHandlerListener[0]));
                }
            }).execute();
            return (GitCommandResult)result.get();
        }
        if (choice == 2) {
            return this.myGit.reset(repository, GitResetMode.HARD, target, new GitLineHandlerListener[0]);
        }
        return null;
    }

    private void notifyResult(Map<GitRepository, GitCommandResult> results) {
        HashMap successes = ContainerUtil.newHashMap();
        HashMap errors = ContainerUtil.newHashMap();
        for (Map.Entry<GitRepository, GitCommandResult> entry : results.entrySet()) {
            GitCommandResult result = entry.getValue();
            GitRepository repository = entry.getKey();
            if (result.success()) {
                successes.put(repository, result);
                continue;
            }
            errors.put(repository, result);
        }
        if (errors.isEmpty()) {
            this.myNotifier.notifySuccess("", "Reset successful");
        } else if (!successes.isEmpty()) {
            this.myNotifier.notifyImportantWarning("Reset partially failed", "Reset was successful for " + GitResetOperation.joinRepos(successes.keySet()) + "<br/>but failed for " + GitResetOperation.joinRepos(errors.keySet()) + ": <br/>" + GitResetOperation.formErrorReport(errors));
        } else {
            this.myNotifier.notifyError("Reset Failed", GitResetOperation.formErrorReport(errors));
        }
    }

    private static String formErrorReport(Map<GitRepository, GitCommandResult> errorResults) {
        MultiMap<String, GitRepository> grouped = GitResetOperation.groupByResult(errorResults);
        if (grouped.size() == 1) {
            return "<code>" + (String)grouped.keySet().iterator().next() + "</code>";
        }
        return StringUtil.join((Collection)grouped.entrySet(), (Function)new Function<Map.Entry<String, Collection<GitRepository>>, String>(){

            public String fun(Map.Entry<String, Collection<GitRepository>> entry) {
                return GitResetOperation.joinRepos(entry.getValue()) + ":<br/><code>" + entry.getKey() + "</code>";
            }
        }, (String)"<br/>");
    }

    private static MultiMap<String, GitRepository> groupByResult(Map<GitRepository, GitCommandResult> results) {
        MultiMap grouped = MultiMap.create();
        for (Map.Entry<GitRepository, GitCommandResult> entry : results.entrySet()) {
            grouped.putValue((Object)entry.getValue().getErrorOutputAsHtmlString(), (Object)entry.getKey());
        }
        return grouped;
    }

    private static String joinRepos(Collection<GitRepository> repositories) {
        return StringUtil.join((Iterable)DvcsUtil.sortRepositories(repositories), (String)", ");
    }

    private static void saveAllDocuments() {
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                FileDocumentManager.getInstance().saveAllDocuments();
            }
        });
    }
}

