/*
 * Decompiled with CFR 0.152.
 */
package git4idea.reset;

import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.ui.VcsLogOneCommitPerRepoAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.log.VcsFullCommitDetails;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.reset.GitNewResetDialog;
import git4idea.reset.GitResetMode;
import git4idea.reset.GitResetOperation;
import java.util.Map;

public class GitResetAction
extends VcsLogOneCommitPerRepoAction<GitRepository> {
    protected AbstractRepositoryManager<GitRepository> getRepositoryManager(Project project) {
        return (AbstractRepositoryManager)ServiceManager.getService((Project)project, GitRepositoryManager.class);
    }

    protected GitRepository getRepositoryForRoot(Project project, VirtualFile root) {
        return (GitRepository)this.getRepositoryManager(project).getRepositoryForRoot(root);
    }

    protected void actionPerformed(final Project project, final Map<GitRepository, VcsFullCommitDetails> commits) {
        GitVcsSettings settings = GitVcsSettings.getInstance(project);
        GitResetMode defaultMode = (GitResetMode)((Object)ObjectUtils.notNull((Object)((Object)settings.getResetMode()), (Object)((Object)GitResetMode.getDefault())));
        GitNewResetDialog dialog = new GitNewResetDialog(project, commits, defaultMode);
        if (dialog.showAndGet()) {
            final GitResetMode selectedMode = dialog.getResetMode();
            settings.setResetMode(selectedMode);
            new Task.Backgroundable(project, "Git reset", false){

                public void run(ProgressIndicator indicator) {
                    new GitResetOperation(project, commits, selectedMode, indicator).execute();
                }
            }.queue();
        }
    }
}

