/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.vfs.VirtualFile;
import git4idea.util.GitFileUtils;
import java.util.Arrays;
import java.util.Collection;

public class GitRepositoryFiles {
    public static final String COMMIT_EDITMSG = "COMMIT_EDITMSG";
    public static final String CONFIG = "config";
    public static final String HEAD = "HEAD";
    public static final String INDEX = "index";
    public static final String INFO = "info";
    public static final String INFO_EXCLUDE = "info/exclude";
    public static final String MERGE_HEAD = "MERGE_HEAD";
    public static final String MERGE_MSG = "MERGE_MSG";
    public static final String REBASE_APPLY = "rebase-apply";
    public static final String REBASE_MERGE = "rebase-merge";
    public static final String PACKED_REFS = "packed-refs";
    public static final String REFS_HEADS = "refs/heads";
    public static final String REFS_REMOTES = "refs/remotes";
    public static final String REFS_TAGS = "refs/tags";
    public static final String SQUASH_MSG = "SQUASH_MSG";
    public static final String GIT_HEAD = ".git" + GitRepositoryFiles.slash("HEAD");
    public static final String GIT_REFS_REMOTES = ".git" + GitRepositoryFiles.slash("refs/remotes");
    public static final String GIT_PACKED_REFS = ".git" + GitRepositoryFiles.slash("packed-refs");
    public static final String GIT_MERGE_HEAD = ".git" + GitRepositoryFiles.slash("MERGE_HEAD");
    public static final String GIT_MERGE_MSG = ".git" + GitRepositoryFiles.slash("MERGE_MSG");
    public static final String GIT_SQUASH_MSG = ".git" + GitRepositoryFiles.slash("SQUASH_MSG");
    public static final String GIT_COMMIT_EDITMSG = ".git" + GitRepositoryFiles.slash("COMMIT_EDITMSG");
    private final String myConfigFilePath;
    private final String myHeadFilePath;
    private final String myIndexFilePath;
    private final String myMergeHeadPath;
    private final String myRebaseApplyPath;
    private final String myRebaseMergePath;
    private final String myPackedRefsPath;
    private final String myRefsHeadsDirPath;
    private final String myRefsRemotesDirPath;
    private final String myRefsTagsPath;
    private final String myCommitMessagePath;
    private final String myExcludePath;

    public static GitRepositoryFiles getInstance(VirtualFile gitDir) {
        return new GitRepositoryFiles(gitDir);
    }

    private GitRepositoryFiles(VirtualFile gitDir) {
        String gitDirPath = GitFileUtils.stripFileProtocolPrefix(gitDir.getPath());
        this.myConfigFilePath = gitDirPath + GitRepositoryFiles.slash(CONFIG);
        this.myHeadFilePath = gitDirPath + GitRepositoryFiles.slash(HEAD);
        this.myIndexFilePath = gitDirPath + GitRepositoryFiles.slash(INDEX);
        this.myMergeHeadPath = gitDirPath + GitRepositoryFiles.slash(MERGE_HEAD);
        this.myCommitMessagePath = gitDirPath + GitRepositoryFiles.slash(COMMIT_EDITMSG);
        this.myRebaseApplyPath = gitDirPath + GitRepositoryFiles.slash(REBASE_APPLY);
        this.myRebaseMergePath = gitDirPath + GitRepositoryFiles.slash(REBASE_MERGE);
        this.myPackedRefsPath = gitDirPath + GitRepositoryFiles.slash(PACKED_REFS);
        this.myRefsHeadsDirPath = gitDirPath + GitRepositoryFiles.slash(REFS_HEADS);
        this.myRefsTagsPath = gitDirPath + GitRepositoryFiles.slash(REFS_TAGS);
        this.myRefsRemotesDirPath = gitDirPath + GitRepositoryFiles.slash(REFS_REMOTES);
        this.myExcludePath = gitDirPath + GitRepositoryFiles.slash(INFO_EXCLUDE);
    }

    private static String slash(String s) {
        return "/" + s;
    }

    static Collection<String> getSubDirRelativePaths() {
        return Arrays.asList(GitRepositoryFiles.slash(REFS_HEADS), GitRepositoryFiles.slash(REFS_REMOTES), GitRepositoryFiles.slash(REFS_TAGS), GitRepositoryFiles.slash(INFO));
    }

    String getRefsHeadsPath() {
        return this.myRefsHeadsDirPath;
    }

    String getRefsRemotesPath() {
        return this.myRefsRemotesDirPath;
    }

    String getRefsTagsPath() {
        return this.myRefsTagsPath;
    }

    public boolean isConfigFile(String filePath) {
        return filePath.equals(this.myConfigFilePath);
    }

    public boolean isIndexFile(String filePath) {
        return filePath.equals(this.myIndexFilePath);
    }

    public boolean isHeadFile(String file) {
        return file.equals(this.myHeadFilePath);
    }

    public boolean isBranchFile(String filePath) {
        return filePath.startsWith(this.myRefsHeadsDirPath);
    }

    public boolean isRemoteBranchFile(String filePath) {
        return filePath.startsWith(this.myRefsRemotesDirPath);
    }

    public boolean isTagFile(String path) {
        return path.startsWith(this.myRefsTagsPath);
    }

    public boolean isRebaseFile(String path) {
        return path.equals(this.myRebaseApplyPath) || path.equals(this.myRebaseMergePath);
    }

    public boolean isMergeFile(String file) {
        return file.equals(this.myMergeHeadPath);
    }

    public boolean isPackedRefs(String file) {
        return file.equals(this.myPackedRefsPath);
    }

    public boolean isCommitMessageFile(String file) {
        return file.equals(this.myCommitMessagePath);
    }

    public boolean isExclude(String path) {
        return path.equals(this.myExcludePath);
    }
}

