/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class GitRemote
implements Comparable<GitRemote> {
    public static final GitRemote DOT = new GitRemote(".", Collections.singletonList("."), Collections.<String>emptyList(), Collections.<String>emptyList(), Collections.<String>emptyList());
    public static final String ORIGIN_NAME = "origin";
    private final String myName;
    private final List<String> myUrls;
    private final Collection<String> myPushUrls;
    final List<String> myFetchRefSpecs;
    private final List<String> myPushRefSpecs;

    public GitRemote(String name, List<String> urls, Collection<String> pushUrls, List<String> fetchRefSpecs, List<String> pushRefSpecs) {
        this.myName = name;
        this.myUrls = urls;
        this.myPushUrls = pushUrls;
        this.myFetchRefSpecs = fetchRefSpecs;
        this.myPushRefSpecs = pushRefSpecs;
    }

    public String getName() {
        return this.myName;
    }

    public List<String> getUrls() {
        return this.myUrls;
    }

    public String getFirstUrl() {
        return this.myUrls.isEmpty() ? null : this.myUrls.get(0);
    }

    public Collection<String> getPushUrls() {
        return this.myPushUrls;
    }

    public List<String> getFetchRefSpecs() {
        return this.myFetchRefSpecs;
    }

    public List<String> getPushRefSpecs() {
        return this.myPushRefSpecs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitRemote gitRemote = (GitRemote)o;
        return this.myName.equals(gitRemote.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public String toString() {
        return String.format("GitRemote{myName='%s', myUrls=%s, myPushUrls=%s, myFetchRefSpec='%s', myPushRefSpec='%s'}", this.myName, this.myUrls, this.myPushUrls, this.myFetchRefSpecs, this.myPushRefSpecs);
    }

    @Override
    public int compareTo(GitRemote o) {
        return this.getName().compareTo(o.getName());
    }
}

