/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.repo.GitRemote;

public class GitBranchTrackInfo {
    private final GitLocalBranch myLocalBranch;
    private final GitRemoteBranch myRemoteBranch;
    private final boolean myMerge;

    public GitBranchTrackInfo(GitLocalBranch localBranch, GitRemoteBranch remoteBranch, boolean merge) {
        this.myLocalBranch = localBranch;
        this.myRemoteBranch = remoteBranch;
        this.myMerge = merge;
    }

    public GitLocalBranch getLocalBranch() {
        return this.myLocalBranch;
    }

    public GitRemote getRemote() {
        return this.myRemoteBranch.getRemote();
    }

    public GitRemoteBranch getRemoteBranch() {
        return this.myRemoteBranch;
    }

    public String toString() {
        return String.format("%s->%s", this.myLocalBranch.getName(), this.myRemoteBranch.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitBranchTrackInfo that = (GitBranchTrackInfo)o;
        if (this.myMerge != that.myMerge) {
            return false;
        }
        if (this.myLocalBranch != null ? !this.myLocalBranch.equals(that.myLocalBranch) : that.myLocalBranch != null) {
            return false;
        }
        return !(this.myRemoteBranch != null ? !this.myRemoteBranch.equals(that.myRemoteBranch) : that.myRemoteBranch != null);
    }

    public int hashCode() {
        int result = this.myLocalBranch != null ? this.myLocalBranch.hashCode() : 0;
        result = 31 * result + (this.myRemoteBranch != null ? this.myRemoteBranch.hashCode() : 0);
        result = 31 * result + (this.myMerge ? 1 : 0);
        return result;
    }
}

