/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import git4idea.config.GitConfigUtil;
import git4idea.rebase.GitRebaseEntry;
import git4idea.util.StringScanner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

class GitInteractiveRebaseFile {
    private static final String CYGDRIVE_PREFIX = "/cygdrive/";
    private final Project myProject;
    private final VirtualFile myRoot;
    private final String myFile;

    GitInteractiveRebaseFile(Project project, VirtualFile root, String rebaseFilePath) {
        this.myProject = project;
        this.myRoot = root;
        this.myFile = GitInteractiveRebaseFile.adjustFilePath(rebaseFilePath);
    }

    public List<GitRebaseEntry> load() throws IOException, NoopException {
        String encoding = GitConfigUtil.getLogEncoding(this.myProject, this.myRoot);
        ArrayList entries = ContainerUtil.newArrayList();
        StringScanner s = new StringScanner(FileUtil.loadFile((File)new File(this.myFile), (String)encoding));
        boolean noop = false;
        while (s.hasMoreData()) {
            if (s.isEol() || s.startsWith('#')) {
                s.nextLine();
                continue;
            }
            if (s.startsWith("noop")) {
                noop = true;
                s.nextLine();
                continue;
            }
            String action = s.spaceToken();
            String hash = s.spaceToken();
            String comment = s.line();
            entries.add(new GitRebaseEntry(action, hash, comment));
        }
        if (noop && entries.isEmpty()) {
            throw new NoopException();
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(this.myFile));
        try {
            out.println("# rebase is cancelled");
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(List<GitRebaseEntry> entries) throws IOException {
        String encoding = GitConfigUtil.getLogEncoding(this.myProject, this.myRoot);
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.myFile), encoding));
        try {
            for (GitRebaseEntry e : entries) {
                if (e.getAction() == GitRebaseEntry.Action.skip) continue;
                out.println(e.getAction().toString() + " " + e.getCommit() + " " + e.getSubject());
            }
        }
        finally {
            out.close();
        }
    }

    private static String adjustFilePath(String file) {
        if (SystemInfo.isWindows && file.startsWith(CYGDRIVE_PREFIX)) {
            int prefixSize = CYGDRIVE_PREFIX.length();
            return file.substring(prefixSize, prefixSize + 1) + ":" + file.substring(prefixSize + 1);
        }
        return file;
    }

    static class NoopException
    extends Exception {
        NoopException() {
        }
    }
}

