/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.push.PushTarget;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitUtil;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.validators.GitRefNameValidator;
import java.text.ParseException;
import java.util.Collection;

public class GitPushTarget
implements PushTarget {
    private static final Logger LOG = Logger.getInstance(GitPushTarget.class);
    private final GitRemoteBranch myRemoteBranch;
    private final boolean myIsNewBranchCreated;

    public GitPushTarget(GitRemoteBranch remoteBranch, boolean isNewBranchCreated) {
        this.myRemoteBranch = remoteBranch;
        this.myIsNewBranchCreated = isNewBranchCreated;
    }

    public GitRemoteBranch getBranch() {
        return this.myRemoteBranch;
    }

    public boolean hasSomethingToPush() {
        return this.isNewBranchCreated();
    }

    public String getPresentation() {
        return this.myRemoteBranch.getNameForRemoteOperations();
    }

    public boolean isNewBranchCreated() {
        return this.myIsNewBranchCreated;
    }

    public static GitPushTarget parse(GitRepository repository, String remoteName, String branchName) throws ParseException {
        if (remoteName == null) {
            throw new ParseException("No remotes defined", -1);
        }
        if (!GitRefNameValidator.getInstance().checkInput(branchName)) {
            throw new ParseException("Invalid destination branch name: " + branchName, -1);
        }
        GitRemote remote = GitPushTarget.findRemote(repository.getRemotes(), remoteName);
        if (remote == null) {
            LOG.error("Remote [" + remoteName + "] is not found among " + repository.getRemotes());
            throw new ParseException("Invalid remote: " + remoteName, -1);
        }
        GitRemoteBranch existingRemoteBranch = GitUtil.findRemoteBranch(repository, remote, branchName);
        if (existingRemoteBranch != null) {
            return new GitPushTarget(existingRemoteBranch, false);
        }
        GitStandardRemoteBranch rb = new GitStandardRemoteBranch(remote, branchName, GitBranch.DUMMY_HASH);
        return new GitPushTarget(rb, true);
    }

    private static GitRemote findRemote(Collection<GitRemote> remotes, final String candidate) {
        return (GitRemote)ContainerUtil.find(remotes, (Condition)new Condition<GitRemote>(){

            public boolean value(GitRemote remote) {
                return remote.getName().equals(candidate);
            }
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GitPushTarget)) {
            return false;
        }
        GitPushTarget target = (GitPushTarget)o;
        if (this.myIsNewBranchCreated != target.myIsNewBranchCreated) {
            return false;
        }
        return this.myRemoteBranch.equals(target.myRemoteBranch);
    }

    public int hashCode() {
        int result = this.myRemoteBranch.hashCode();
        result = 31 * result + (this.myIsNewBranchCreated ? 1 : 0);
        return result;
    }
}

