/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.push.GitPushNativeResult;
import git4idea.update.GitUpdateResult;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

class GitPushRepoResult {
    static Comparator<Type> TYPE_COMPARATOR = new Comparator<Type>(){

        @Override
        public int compare(Type o1, Type o2) {
            return o1.ordinal() - o2.ordinal();
        }
    };
    private final Type myType;
    private final int myCommits;
    private final String mySourceBranch;
    private final String myTargetBranch;
    private final String myTargetRemote;
    private final List<String> myPushedTags;
    private final String myError;
    private final GitUpdateResult myUpdateResult;

    static GitPushRepoResult convertFromNative(GitPushNativeResult result, List<GitPushNativeResult> tagResults, int commits, GitLocalBranch source, GitRemoteBranch target) {
        List tags = ContainerUtil.map(tagResults, (Function)new Function<GitPushNativeResult, String>(){

            public String fun(GitPushNativeResult result) {
                return result.getSourceRef();
            }
        });
        return new GitPushRepoResult(GitPushRepoResult.convertType(result.getType()), commits, source.getFullName(), target.getFullName(), target.getRemote().getName(), tags, null, null);
    }

    static GitPushRepoResult error(GitLocalBranch source, GitRemoteBranch target, String error) {
        return new GitPushRepoResult(Type.ERROR, -1, source.getFullName(), target.getFullName(), target.getRemote().getName(), Collections.<String>emptyList(), error, null);
    }

    static GitPushRepoResult notPushed(GitLocalBranch source, GitRemoteBranch target) {
        return new GitPushRepoResult(Type.NOT_PUSHED, -1, source.getFullName(), target.getFullName(), target.getRemote().getName(), Collections.<String>emptyList(), null, null);
    }

    static GitPushRepoResult addUpdateResult(GitPushRepoResult original, GitUpdateResult updateResult) {
        return new GitPushRepoResult(original.getType(), original.getNumberOfPushedCommits(), original.getSourceBranch(), original.getTargetBranch(), original.getTargetRemote(), original.getPushedTags(), original.getError(), updateResult);
    }

    private GitPushRepoResult(Type type, int pushedCommits, String sourceBranch, String targetBranch, String targetRemote, List<String> pushedTags, String error, GitUpdateResult result) {
        this.myType = type;
        this.myCommits = pushedCommits;
        this.mySourceBranch = sourceBranch;
        this.myTargetBranch = targetBranch;
        this.myTargetRemote = targetRemote;
        this.myPushedTags = pushedTags;
        this.myError = error;
        this.myUpdateResult = result;
    }

    Type getType() {
        return this.myType;
    }

    GitUpdateResult getUpdateResult() {
        return this.myUpdateResult;
    }

    int getNumberOfPushedCommits() {
        return this.myCommits;
    }

    String getSourceBranch() {
        return this.mySourceBranch;
    }

    String getTargetBranch() {
        return this.myTargetBranch;
    }

    String getError() {
        return this.myError;
    }

    List<String> getPushedTags() {
        return this.myPushedTags;
    }

    public String getTargetRemote() {
        return this.myTargetRemote;
    }

    private static Type convertType(GitPushNativeResult.Type nativeType) {
        switch (nativeType) {
            case SUCCESS: {
                return Type.SUCCESS;
            }
            case FORCED_UPDATE: {
                return Type.FORCED;
            }
            case NEW_REF: {
                return Type.NEW_BRANCH;
            }
            case REJECTED: {
                return Type.REJECTED;
            }
            case UP_TO_DATE: {
                return Type.UP_TO_DATE;
            }
            case ERROR: {
                return Type.ERROR;
            }
        }
        throw new IllegalArgumentException("Conversion is not supported: " + (Object)((Object)nativeType));
    }

    public String toString() {
        return String.format("%s (%d, '%s'), update: %s}", new Object[]{this.myType, this.myCommits, this.mySourceBranch, this.myUpdateResult});
    }

    static enum Type {
        SUCCESS,
        NEW_BRANCH,
        UP_TO_DATE,
        FORCED,
        REJECTED,
        ERROR,
        NOT_PUSHED;

    }
}

