/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHashFilter;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.graph.impl.facade.bek.BekSorter;
import git4idea.log.GitLogProvider;
import java.util.Collections;
import java.util.List;
import java.util.Set;

class GitBekParentFixer {
    private static final String MAGIC_TEXT = "Merge remote";
    private static final VcsLogFilterCollection MAGIC_FILTER = GitBekParentFixer.createVcsLogFilterCollection();
    private final Set<Hash> myWrongCommits;

    private GitBekParentFixer(Set<Hash> wrongCommits) {
        this.myWrongCommits = wrongCommits;
    }

    static GitBekParentFixer prepare(VirtualFile root, GitLogProvider provider) throws VcsException {
        if (!BekSorter.isBekEnabled()) {
            return new GitBekParentFixer(Collections.<Hash>emptySet());
        }
        return new GitBekParentFixer(GitBekParentFixer.getWrongCommits(provider, root));
    }

    TimedVcsCommit fixCommit(TimedVcsCommit commit) {
        if (!this.myWrongCommits.contains(commit.getId())) {
            return commit;
        }
        return GitBekParentFixer.reverseParents(commit);
    }

    private static Set<Hash> getWrongCommits(GitLogProvider provider, VirtualFile root) throws VcsException {
        List<TimedVcsCommit> commitsMatchingFilter = provider.getCommitsMatchingFilter(root, MAGIC_FILTER, -1);
        return ContainerUtil.map2Set(commitsMatchingFilter, (Function)new Function<TimedVcsCommit, Hash>(){

            public Hash fun(TimedVcsCommit timedVcsCommit) {
                return (Hash)timedVcsCommit.getId();
            }
        });
    }

    private static TimedVcsCommit reverseParents(final TimedVcsCommit commit) {
        return new TimedVcsCommit(){

            public long getTimestamp() {
                return commit.getTimestamp();
            }

            public Hash getId() {
                return (Hash)commit.getId();
            }

            public List<Hash> getParents() {
                return ContainerUtil.reverse((List)commit.getParents());
            }
        };
    }

    private static VcsLogFilterCollection createVcsLogFilterCollection() {
        final VcsLogTextFilter textFilter = new VcsLogTextFilter(){

            public String getText() {
                return GitBekParentFixer.MAGIC_TEXT;
            }

            public boolean matches(VcsCommitMetadata details) {
                return details.getFullMessage().contains(GitBekParentFixer.MAGIC_TEXT);
            }
        };
        return new VcsLogFilterCollection(){

            public VcsLogBranchFilter getBranchFilter() {
                return null;
            }

            public VcsLogUserFilter getUserFilter() {
                return null;
            }

            public VcsLogDateFilter getDateFilter() {
                return null;
            }

            public VcsLogTextFilter getTextFilter() {
                return textFilter;
            }

            public VcsLogHashFilter getHashFilter() {
                return null;
            }

            public VcsLogStructureFilter getStructureFilter() {
                return null;
            }

            public VcsLogRootFilter getRootFilter() {
                return null;
            }

            public boolean isEmpty() {
                return false;
            }

            public List<VcsLogDetailsFilter> getDetailsFilters() {
                return Collections.singletonList(textFilter);
            }
        };
    }
}

