/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GitCommandResult {
    private final boolean mySuccess;
    private final int myExitCode;
    private final List<String> myErrorOutput;
    private final List<String> myOutput;
    private final Throwable myException;

    public GitCommandResult(boolean success, int exitCode, List<String> errorOutput, List<String> output, Throwable exception) {
        this.myExitCode = exitCode;
        this.mySuccess = success;
        this.myErrorOutput = errorOutput;
        this.myOutput = output;
        this.myException = exception;
    }

    public boolean success() {
        return this.mySuccess;
    }

    public List<String> getOutput() {
        return new ArrayList<String>(this.myOutput);
    }

    public String toString() {
        return String.format("{%d} %nOutput: %n%s %nError output: %n%s", this.myExitCode, this.myOutput, this.myErrorOutput);
    }

    public String getErrorOutputAsHtmlString() {
        return StringUtil.join(GitCommandResult.cleanup(this.myErrorOutput), (String)"<br/>");
    }

    public String getErrorOutputAsJoinedString() {
        return StringUtil.join(this.myErrorOutput, (String)"\n");
    }

    public String getOutputAsJoinedString() {
        return StringUtil.join(this.myOutput, (String)"\n");
    }

    public Throwable getException() {
        return this.myException;
    }

    public static GitCommandResult error(String error) {
        return new GitCommandResult(false, 1, Collections.singletonList(error), Collections.<String>emptyList(), null);
    }

    public boolean cancelled() {
        return false;
    }

    private static Collection<String> cleanup(Collection<String> errorOutput) {
        return ContainerUtil.map(errorOutput, (Function)new Function<String, String>(){

            public String fun(String errorMessage) {
                return GitUtil.cleanupErrorPrefixes(errorMessage);
            }
        });
    }
}

